/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters.AbstractAutoCrafter;
import io.github.thebusybiscuit.slimefun4.implementation.items.autocrafters.AbstractRecipe;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AsyncRecipeChoiceTask;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.data.PersistentDataAPI;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.persistence.PersistentDataHolder;

public class VanillaAutoCrafter
extends AbstractAutoCrafter {
    @ParametersAreNonnullByDefault
    public VanillaAutoCrafter(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    @Nullable
    public AbstractRecipe getSelectedRecipe(@Nonnull Block b) {
        return AbstractRecipe.of(this.getRecipe(b));
    }

    @Nullable
    private Recipe getRecipe(@Nonnull Block b) {
        String value;
        BlockState state = PaperLib.getBlockState(b, false).getState();
        if (state instanceof Skull && (value = PersistentDataAPI.getString((PersistentDataHolder)((Skull)state), this.recipeStorageKey)) != null) {
            String[] values = PatternUtils.COLON.split(value);
            NamespacedKey key = new NamespacedKey(values[0], values[1]);
            return SlimefunPlugin.getMinecraftRecipeService().getRecipe(key);
        }
        return null;
    }

    @Override
    protected boolean matches(@Nonnull ItemStack item, @Nonnull Predicate<ItemStack> predicate) {
        SlimefunItem sfItem = SlimefunItem.getByItem(item);
        if (sfItem == null || sfItem.isUseableInWorkbench()) {
            return super.matches(item, predicate);
        }
        return false;
    }

    @Override
    protected void updateRecipe(@Nonnull Block b, @Nonnull Player p) {
        ItemStack item = p.getInventory().getItemInMainHand();
        List<Recipe> recipes = this.getRecipesFor(item);
        if (recipes.isEmpty()) {
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.no-recipes");
        } else {
            ChestMenu menu = new ChestMenu(this.getItemName());
            menu.setPlayerInventoryClickable(false);
            menu.setEmptySlotsClickable(false);
            ChestMenuUtils.drawBackground(menu, this.background);
            ChestMenuUtils.drawBackground(menu, 45, 47, 48, 50, 51, 53);
            AsyncRecipeChoiceTask task = new AsyncRecipeChoiceTask();
            this.offerRecipe(p, b, recipes, 0, menu, task);
            menu.open(p);
            task.start(menu.toInventory());
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        }
    }

    @ParametersAreNonnullByDefault
    private void offerRecipe(Player p, Block b, List<Recipe> recipes, int index, ChestMenu menu, AsyncRecipeChoiceTask task) {
        Validate.isTrue((index >= 0 && index < recipes.size() ? 1 : 0) != 0, (String)("page must be between 0 and " + (recipes.size() - 1)));
        menu.replaceExistingItem(46, ChestMenuUtils.getPreviousButton(p, index + 1, recipes.size()));
        menu.addMenuClickHandler(46, (pl, slot, item, action) -> {
            if (index > 0) {
                pl.playSound(pl.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.offerRecipe(p, b, recipes, index - 1, menu, task);
            }
            return false;
        });
        menu.replaceExistingItem(52, ChestMenuUtils.getNextButton(p, index + 1, recipes.size()));
        menu.addMenuClickHandler(52, (pl, slot, item, action) -> {
            if (index < recipes.size() - 1) {
                pl.playSound(pl.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                this.offerRecipe(p, b, recipes, index + 1, menu, task);
            }
            return false;
        });
        AbstractRecipe recipe = AbstractRecipe.of(recipes.get(index));
        menu.replaceExistingItem(49, new CustomItem(Material.CRAFTING_TABLE, ChatColor.GREEN + SlimefunPlugin.getLocalization().getMessage(p, "messages.auto-crafting.select"), new String[0]));
        menu.addMenuClickHandler(49, (pl, slot, item, action) -> {
            this.setSelectedRecipe(b, recipe);
            pl.closeInventory();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.recipe-set");
            this.showRecipe(p, b, recipe);
            return false;
        });
        task.clear();
        recipe.show(menu, task);
    }

    @Nonnull
    private List<Recipe> getRecipesFor(@Nonnull ItemStack item) {
        ArrayList<Recipe> recipes = new ArrayList<Recipe>();
        for (Recipe recipe : Bukkit.getRecipesFor((ItemStack)item)) {
            if (!(recipe instanceof ShapedRecipe) && !(recipe instanceof ShapelessRecipe)) continue;
            recipes.add(recipe);
        }
        return recipes;
    }
}

