/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.utils;

import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;

public final class NumberUtils {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ROOT));

    private NumberUtils() {
    }

    @Nonnull
    public static String formatBigNumber(int number) {
        return NumberFormat.getNumberInstance(Locale.US).format(number);
    }

    @Nonnull
    public static String getCompactDouble(double value) {
        if (value < 0.0) {
            return '-' + NumberUtils.getCompactDouble(-value);
        }
        if (value < 1000.0) {
            return DECIMAL_FORMAT.format(value);
        }
        if (value < 1000000.0) {
            return DECIMAL_FORMAT.format(value / 1000.0) + 'K';
        }
        if (value < 1.0E9) {
            return DECIMAL_FORMAT.format(value / 1000000.0) + 'M';
        }
        if (value < 1.0E12) {
            return DECIMAL_FORMAT.format(value / 1.0E9) + 'B';
        }
        if (value < 1.0E15) {
            return DECIMAL_FORMAT.format(value / 1.0E12) + 'T';
        }
        return DECIMAL_FORMAT.format(value / 1.0E15) + 'Q';
    }

    @Nonnull
    public static LocalDateTime parseGitHubDate(@Nonnull String date) {
        Validate.notNull((Object)date, (String)"Provided date was null");
        return LocalDateTime.parse(date.substring(0, date.length() - 1));
    }

    @Nonnull
    public static ChatColor getColorFromPercentage(float percentage) {
        if (percentage < 16.0f) {
            return ChatColor.DARK_RED;
        }
        if (percentage < 32.0f) {
            return ChatColor.RED;
        }
        if (percentage < 48.0f) {
            return ChatColor.GOLD;
        }
        if (percentage < 64.0f) {
            return ChatColor.YELLOW;
        }
        if (percentage < 80.0f) {
            return ChatColor.DARK_GREEN;
        }
        return ChatColor.GREEN;
    }

    @Nonnull
    public static String getElapsedTime(@Nonnull LocalDateTime date) {
        return NumberUtils.getElapsedTime(LocalDateTime.now(), date);
    }

    @Nonnull
    public static String getElapsedTime(@Nonnull LocalDateTime current, @Nonnull LocalDateTime priorDate) {
        Validate.notNull((Object)current, (String)"Provided current date was null");
        Validate.notNull((Object)priorDate, (String)"Provided past date was null");
        long hours = Duration.between(priorDate, current).toHours();
        if (hours == 0L) {
            return "< 1h";
        }
        if (hours / 24L == 0L) {
            return hours % 24L + "h";
        }
        if (hours % 24L == 0L) {
            return hours / 24L + "d";
        }
        return hours / 24L + "d " + hours % 24L + "h";
    }

    @Nonnull
    public static String getTimeLeft(int seconds) {
        String timeleft = "";
        int minutes = (int)((long)seconds / 60L);
        if (minutes > 0) {
            timeleft = timeleft + minutes + "m ";
        }
        return timeleft + (seconds -= minutes * 60) + "s";
    }

    public static int getInt(@Nonnull String str, int defaultValue) {
        if (PatternUtils.NUMERIC.matcher(str).matches()) {
            return Integer.parseInt(str);
        }
        return defaultValue;
    }

    @Nonnull
    public static String getAsMillis(long nanoseconds) {
        if (nanoseconds == 0L) {
            return "0ms";
        }
        String number = NumberUtils.roundDecimalNumber((double)nanoseconds / 1000000.0);
        String[] parts = PatternUtils.NUMBER_SEPARATOR.split(number);
        if (parts.length == 1) {
            return parts[0] + "ms";
        }
        return parts[0] + '.' + parts[1] + "ms";
    }

    @Nonnull
    public static String roundDecimalNumber(double number) {
        return DECIMAL_FORMAT.format(number);
    }

    public static double reparseDouble(double number) {
        return Double.valueOf(NumberUtils.roundDecimalNumber(number));
    }

    public static long getLong(@Nullable Long value, long defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static int getInt(@Nullable Integer value, int defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static float getFloat(@Nullable Float value, float defaultValue) {
        return value == null ? defaultValue : value.floatValue();
    }

    public static int clamp(int min, int value, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }
}

