/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.auto_crafters;

import io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.auto_crafters.AbstractRecipe;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AsyncRecipeChoiceTask;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.ItemStack;

class SlimefunItemRecipe
extends AbstractRecipe {
    private final int[] slots = new int[]{11, 12, 13, 20, 21, 22, 29, 30, 31};
    private final SlimefunItem item;

    SlimefunItemRecipe(@Nonnull SlimefunItem item) {
        super(SlimefunItemRecipe.getInputs(item), item.getRecipeOutput());
        this.item = item;
    }

    @Nonnull
    private static Collection<Predicate<ItemStack>> getInputs(@Nonnull SlimefunItem item) {
        ArrayList<Predicate<ItemStack>> predicates = new ArrayList<Predicate<ItemStack>>();
        for (int i = 0; i < 9; ++i) {
            ItemStack ingredient = item.getRecipe()[i];
            if (ingredient == null || ingredient.getType().isAir()) continue;
            predicates.add(stack -> SlimefunUtils.isItemSimilar(stack, ingredient, true));
        }
        return predicates;
    }

    @Override
    public void show(@Nonnull ChestMenu menu, @Nonnull AsyncRecipeChoiceTask task) {
        Validate.notNull((Object)menu, (String)"The ChestMenu cannot be null!");
        Validate.notNull((Object)task, (String)"The RecipeChoiceTask cannot be null!");
        menu.addItem(24, this.getResult().clone(), ChestMenuUtils.getEmptyClickHandler());
        ItemStack[] recipe = this.item.getRecipe();
        for (int i = 0; i < 9; ++i) {
            menu.addItem(this.slots[i], recipe[i], ChestMenuUtils.getEmptyClickHandler());
        }
    }

    public String toString() {
        return this.item.getId();
    }
}

