/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.auto_crafters;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.auto_crafters.AbstractAutoCrafter;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.auto_crafters.AbstractRecipe;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AsyncRecipeChoiceTask;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.data.PersistentDataAPI;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;

public class SlimefunAutoCrafter
extends AbstractAutoCrafter {
    private final RecipeType targetRecipeType;

    @ParametersAreNonnullByDefault
    protected SlimefunAutoCrafter(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, RecipeType targetRecipeType) {
        super(category, item, recipeType, recipe);
        this.targetRecipeType = targetRecipeType;
    }

    @Override
    @Nullable
    public AbstractRecipe getSelectedRecipe(@Nonnull Block b) {
        String value;
        SlimefunItem item;
        Validate.notNull((Object)b, (String)"The Block cannot be null!");
        BlockState state = PaperLib.getBlockState(b, false).getState();
        if (state instanceof Skull && (item = SlimefunItem.getByID(value = PersistentDataAPI.getString((PersistentDataHolder)((Skull)state), this.recipeStorageKey))) != null) {
            return AbstractRecipe.of(item, this.targetRecipeType);
        }
        return null;
    }

    @Override
    protected void updateRecipe(@Nonnull Block b, @Nonnull Player p) {
        ItemStack itemInHand = p.getInventory().getItemInMainHand();
        SlimefunItem item = SlimefunItem.getByItem(itemInHand);
        if (item != null && item.getRecipeType().equals(this.targetRecipeType)) {
            if (item.canUse(p, true)) {
                AbstractRecipe recipe = AbstractRecipe.of(item, this.targetRecipeType);
                if (recipe != null) {
                    ChestMenu menu = new ChestMenu(this.getItemName());
                    menu.setPlayerInventoryClickable(false);
                    menu.setEmptySlotsClickable(false);
                    ChestMenuUtils.drawBackground(menu, this.background);
                    ChestMenuUtils.drawBackground(menu, 45, 46, 47, 48, 50, 51, 52, 53);
                    menu.addItem(49, new CustomItem(Material.CRAFTING_TABLE, ChatColor.GREEN + SlimefunPlugin.getLocalization().getMessage(p, "messages.auto-crafting.select"), new String[0]));
                    menu.addMenuClickHandler(49, (pl, stack, slot, action) -> {
                        this.setSelectedRecipe(b, recipe);
                        p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.recipe-set");
                        this.showRecipe(p, b, recipe);
                        return false;
                    });
                    AsyncRecipeChoiceTask task = new AsyncRecipeChoiceTask();
                    recipe.show(menu, task);
                    menu.open(p);
                    p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    if (!task.isEmpty()) {
                        task.start(menu.toInventory());
                    }
                } else {
                    SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.no-recipes");
                }
            }
        } else {
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.no-recipes");
        }
    }
}

