/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.auto_crafters;

import io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.auto_crafters.SlimefunItemRecipe;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.auto_crafters.VanillaRecipe;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AsyncRecipeChoiceTask;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import org.apache.commons.lang.Validate;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public abstract class AbstractRecipe {
    private final Collection<Predicate<ItemStack>> ingredients;
    private final ItemStack result;

    @ParametersAreNonnullByDefault
    protected AbstractRecipe(Collection<Predicate<ItemStack>> ingredients, ItemStack result) {
        Validate.notEmpty(ingredients, (String)"The input predicates cannot be null or an empty array");
        Validate.notNull((Object)result, (String)"The recipe result must not be null!");
        this.ingredients = ingredients;
        this.result = result;
    }

    @Nonnull
    public Collection<Predicate<ItemStack>> getIngredients() {
        return this.ingredients;
    }

    @Nonnull
    public ItemStack getResult() {
        return this.result;
    }

    public abstract void show(@Nonnull ChestMenu var1, @Nonnull AsyncRecipeChoiceTask var2);

    @Nullable
    public static AbstractRecipe of(@Nullable Recipe recipe) {
        if (recipe instanceof ShapedRecipe) {
            return new VanillaRecipe((ShapedRecipe)recipe);
        }
        if (recipe instanceof ShapelessRecipe) {
            return new VanillaRecipe((ShapelessRecipe)recipe);
        }
        return null;
    }

    @Nullable
    public static AbstractRecipe of(@Nullable SlimefunItem item, @Nonnull RecipeType recipeType) {
        if (item != null && item.getRecipeType().equals(recipeType)) {
            return new SlimefunItemRecipe(item);
        }
        return null;
    }
}

