/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.auto_crafters;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemState;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.auto_crafters.AbstractRecipe;
import io.github.thebusybiscuit.slimefun4.implementation.tasks.AsyncRecipeChoiceTask;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.data.PersistentDataAPI;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;

public abstract class AbstractAutoCrafter
extends SlimefunItem
implements EnergyNetComponent {
    private int energyConsumed = -1;
    private int energyCapacity = -1;
    protected final NamespacedKey recipeStorageKey;
    protected final int[] background = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 14, 15, 16, 17, 18, 19, 23, 25, 26, 27, 28, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44};

    @ParametersAreNonnullByDefault
    public AbstractAutoCrafter(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.recipeStorageKey = new NamespacedKey((Plugin)SlimefunPlugin.instance(), "recipe_key");
        this.addItemHandler(this.onRightClick());
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem item, Config data) {
                AbstractAutoCrafter.this.tick(b, data);
            }

            @Override
            public boolean isSynchronized() {
                return true;
            }
        });
    }

    @Nonnull
    private BlockUseHandler onRightClick() {
        return e -> e.getClickedBlock().ifPresent(b -> {
            Player p = e.getPlayer();
            e.cancel();
            if (!this.isValidChest(b.getRelative(BlockFace.DOWN))) {
                SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.missing-chest");
            } else if (SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, (Block)b, ProtectableAction.INTERACT_BLOCK)) {
                if (p.isSneaking()) {
                    this.updateRecipe((Block)b, p);
                } else {
                    AbstractRecipe recipe = this.getSelectedRecipe((Block)b);
                    if (recipe == null) {
                        SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.select-a-recipe");
                    } else {
                        this.showRecipe(p, (Block)b, recipe);
                    }
                }
            }
        });
    }

    protected void tick(@Nonnull Block b, @Nonnull Config data) {
        Inventory inv;
        BlockState state;
        AbstractRecipe recipe = this.getSelectedRecipe(b);
        if (recipe == null || this.getCharge(b.getLocation(), data) < this.getEnergyConsumption()) {
            return;
        }
        Block chest = b.getRelative(BlockFace.DOWN);
        if (this.isValidChest(chest) && (state = PaperLib.getBlockState(chest, false).getState()) instanceof InventoryHolder && this.craft(inv = ((InventoryHolder)state).getInventory(), recipe)) {
            Location loc = b.getLocation().add(0.5, 0.8, 0.5);
            b.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, loc, 6);
            this.removeCharge(b.getLocation(), this.getEnergyConsumption());
        }
    }

    protected boolean isValidChest(@Nonnull Block block) {
        return block.getType() == Material.CHEST;
    }

    @Nullable
    public abstract AbstractRecipe getSelectedRecipe(@Nonnull Block var1);

    protected abstract void updateRecipe(@Nonnull Block var1, @Nonnull Player var2);

    protected void setSelectedRecipe(@Nonnull Block b, @Nullable AbstractRecipe recipe) {
        BlockState state = PaperLib.getBlockState(b, false).getState();
        if (state instanceof Skull) {
            if (recipe == null) {
                PersistentDataAPI.remove((PersistentDataHolder)((Skull)state), this.recipeStorageKey);
            } else {
                PersistentDataAPI.setString((PersistentDataHolder)((Skull)state), this.recipeStorageKey, recipe.toString());
            }
        }
    }

    @ParametersAreNonnullByDefault
    protected void showRecipe(Player p, Block b, AbstractRecipe recipe) {
        Validate.notNull((Object)p, (String)"The Player should not be null");
        Validate.notNull((Object)b, (String)"The Block should not be null");
        Validate.notNull((Object)recipe, (String)"The Recipe should not be null");
        ChestMenu menu = new ChestMenu(this.getItemName());
        menu.setPlayerInventoryClickable(false);
        menu.setEmptySlotsClickable(false);
        ChestMenuUtils.drawBackground(menu, this.background);
        ChestMenuUtils.drawBackground(menu, 45, 46, 47, 48, 50, 51, 52, 53);
        menu.addItem(49, new CustomItem(Material.BARRIER, ChatColor.RED + SlimefunPlugin.getLocalization().getMessage(p, "messages.auto-crafting.remove"), new String[0]));
        menu.addMenuClickHandler(49, (pl, item, slot, action) -> {
            this.setSelectedRecipe(b, null);
            pl.closeInventory();
            p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "messages.auto-crafting.recipe-removed");
            return false;
        });
        AsyncRecipeChoiceTask task = new AsyncRecipeChoiceTask();
        recipe.show(menu, task);
        menu.open(p);
        p.playSound(p.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        if (!task.isEmpty()) {
            task.start(menu.toInventory());
        }
    }

    @ParametersAreNonnullByDefault
    protected boolean matches(ItemStack item, Predicate<ItemStack> predicate) {
        return predicate.test(item);
    }

    @ParametersAreNonnullByDefault
    protected boolean matchesAny(Inventory inv, Map<Integer, Integer> itemQuantities, Predicate<ItemStack> predicate) {
        ItemStack[] contents = inv.getContents();
        for (int slot = 0; slot < contents.length; ++slot) {
            int amount;
            ItemStack item = contents[slot];
            if (item == null || (amount = itemQuantities.getOrDefault(slot, item.getAmount()).intValue()) <= 0 || !this.matches(item, predicate)) continue;
            itemQuantities.put(slot, amount - 1);
            return true;
        }
        return false;
    }

    public boolean craft(@Nonnull Inventory inv, @Nonnull AbstractRecipe recipe) {
        Validate.notNull((Object)inv, (String)"The Inventory must not be null");
        Validate.notNull((Object)recipe, (String)"The Recipe shall not be null");
        if (inv.firstEmpty() != -1) {
            HashMap<Integer, Integer> itemQuantities = new HashMap<Integer, Integer>();
            for (Predicate<ItemStack> predicate : recipe.getIngredients()) {
                if (this.matchesAny(inv, itemQuantities, predicate)) continue;
                return false;
            }
            for (Map.Entry entry : itemQuantities.entrySet()) {
                ItemStack item = inv.getItem(((Integer)entry.getKey()).intValue());
                if (item == null) continue;
                item.setAmount(((Integer)entry.getValue()).intValue());
            }
            return inv.addItem(new ItemStack[]{recipe.getResult().clone()}).isEmpty();
        }
        return false;
    }

    @Override
    public int getCapacity() {
        return this.energyCapacity;
    }

    public int getEnergyConsumption() {
        return this.energyConsumed;
    }

    @Nonnull
    public final AbstractAutoCrafter setCapacity(int capacity) {
        Validate.isTrue((capacity > 0 ? 1 : 0) != 0, (String)"The capacity must be greater than zero!");
        if (this.getState() == ItemState.UNREGISTERED) {
            this.energyCapacity = capacity;
            return this;
        }
        throw new IllegalStateException("You cannot modify the capacity after the Item was registered.");
    }

    @Nonnull
    public final AbstractAutoCrafter setEnergyConsumption(int energyConsumption) {
        Validate.isTrue((energyConsumption > 0 ? 1 : 0) != 0, (String)"The energy consumption must be greater than zero!");
        Validate.isTrue((this.energyCapacity > 0 ? 1 : 0) != 0, (String)"You must specify the capacity before you can set the consumption amount.");
        Validate.isTrue((energyConsumption <= this.energyCapacity ? 1 : 0) != 0, (String)("The energy consumption cannot be higher than the capacity (" + this.energyCapacity + ')'));
        this.energyConsumed = energyConsumption;
        return this;
    }

    @Override
    public void register(@Nonnull SlimefunAddon addon) {
        this.addon = addon;
        if (this.getCapacity() <= 0) {
            this.warn("The capacity has not been configured correctly. The Item was disabled.");
            this.warn("Make sure to call '" + this.getClass().getSimpleName() + "#setEnergyCapacity(...)' before registering!");
        }
        if (this.getEnergyConsumption() <= 0) {
            this.warn("The energy consumption has not been configured correctly. The Item was disabled.");
            this.warn("Make sure to call '" + this.getClass().getSimpleName() + "#setEnergyConsumption(...)' before registering!");
        }
        if (this.getCapacity() > 0 && this.getEnergyConsumption() > 0) {
            super.register(addon);
        }
    }

    @Override
    public final EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }
}

