/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.api.items.settings.IntRangeSetting;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import org.bukkit.Material;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class GrapplingHook
extends SimpleSlimefunItem<ItemUseHandler> {
    private final ItemSetting<Boolean> consumeOnUse = new ItemSetting<Boolean>(this, "consume-on-use", true);
    private final ItemSetting<Integer> despawnTicks = new IntRangeSetting(this, "despawn-seconds", 0, 60, Integer.MAX_VALUE);

    @ParametersAreNonnullByDefault
    public GrapplingHook(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemSetting(this.despawnTicks);
        this.addItemSetting(this.consumeOnUse);
    }

    @Override
    public ItemUseHandler getItemHandler() {
        return e -> {
            Player p = e.getPlayer();
            UUID uuid = p.getUniqueId();
            boolean isConsumed = this.consumeOnUse.getValue();
            if (!e.getClickedBlock().isPresent() && !SlimefunPlugin.getGrapplingHookListener().isGrappling(uuid)) {
                e.cancel();
                if (p.getInventory().getItemInOffHand().getType() == Material.BOW) {
                    return;
                }
                ItemStack item = e.getItem();
                if (item.getType() == Material.LEAD && isConsumed) {
                    ItemUtils.consumeItem(item, false);
                }
                Vector direction = p.getEyeLocation().getDirection().multiply(2.0);
                Arrow arrow = (Arrow)p.getWorld().spawn(p.getEyeLocation().add(direction.getX(), direction.getY(), direction.getZ()), Arrow.class);
                arrow.setShooter((ProjectileSource)p);
                arrow.setVelocity(direction);
                Bat bat = (Bat)p.getWorld().spawnEntity(p.getLocation(), EntityType.BAT);
                bat.setCanPickupItems(false);
                bat.setAI(false);
                bat.setSilent(true);
                bat.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 100000, 100000));
                bat.setLeashHolder((Entity)arrow);
                boolean state = item.getType() != Material.SHEARS;
                SlimefunPlugin.getGrapplingHookListener().addGrapplingHook(p, arrow, bat, state, this.despawnTicks.getValue().intValue(), isConsumed);
            }
        };
    }
}

