/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.holograms;

import io.github.thebusybiscuit.slimefun4.core.services.holograms.Hologram;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.cscorelib2.blocks.BlockPosition;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class HologramsService {
    private static final double RADIUS = 0.45;
    private static final long PURGE_RATE = 900L;
    private final Plugin plugin;
    private final Vector defaultOffset = new Vector(0.5, 0.75, 0.5);
    private final NamespacedKey persistentDataKey;
    private final Map<BlockPosition, Hologram> cache = new HashMap<BlockPosition, Hologram>();

    public HologramsService(@Nonnull Plugin plugin) {
        this.plugin = plugin;
        this.persistentDataKey = new NamespacedKey(plugin, "hologram_id");
    }

    public void start() {
        this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask(this.plugin, this::purge, 900L, 900L);
    }

    @Nonnull
    public Vector getDefaultOffset() {
        return this.defaultOffset;
    }

    private void purge() {
        Iterator<Hologram> iterator = this.cache.values().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().hasExpired()) continue;
            iterator.remove();
        }
    }

    @Nullable
    private Hologram getHologram(@Nonnull Location loc, boolean createIfNoneExists) {
        Validate.notNull((Object)loc, (String)"Location cannot be null");
        BlockPosition position = new BlockPosition(loc);
        Hologram hologram = this.cache.get(position);
        if (hologram != null && !hologram.hasDespawned()) {
            return hologram;
        }
        Collection holograms = loc.getWorld().getNearbyEntities(loc, 0.45, 0.45, 0.45, this::isHologram);
        for (Entity n : holograms) {
            if (!(n instanceof ArmorStand)) continue;
            PersistentDataContainer container = n.getPersistentDataContainer();
            if (container.has(this.persistentDataKey, PersistentDataType.LONG)) {
                if (!((Long)container.get(this.persistentDataKey, PersistentDataType.LONG)).equals(position.getPosition())) continue;
                return this.getAsHologram(position, n, container);
            }
            container.set(this.persistentDataKey, PersistentDataType.LONG, (Object)position.getPosition());
            return this.getAsHologram(position, n, container);
        }
        if (createIfNoneExists) {
            ArmorStand armorstand = (ArmorStand)loc.getWorld().spawnEntity(loc, EntityType.ARMOR_STAND);
            PersistentDataContainer container = armorstand.getPersistentDataContainer();
            return this.getAsHologram(position, (Entity)armorstand, container);
        }
        return null;
    }

    private boolean isHologram(@Nonnull Entity n) {
        if (n instanceof ArmorStand) {
            ArmorStand armorstand = (ArmorStand)n;
            return !armorstand.isVisible() && armorstand.isSilent() && !armorstand.hasGravity();
        }
        return false;
    }

    @Nullable
    private Hologram getAsHologram(@Nonnull BlockPosition position, @Nonnull Entity entity, @Nonnull PersistentDataContainer container) {
        if (entity instanceof ArmorStand) {
            ArmorStand armorstand = (ArmorStand)entity;
            armorstand.setVisible(false);
            armorstand.setInvulnerable(true);
            armorstand.setSilent(true);
            armorstand.setMarker(true);
            armorstand.setAI(false);
            armorstand.setGravity(false);
            armorstand.setRemoveWhenFarAway(false);
            container.set(this.persistentDataKey, PersistentDataType.LONG, (Object)position.getPosition());
            Hologram hologram = new Hologram(armorstand.getUniqueId());
            this.cache.put(position, hologram);
            return hologram;
        }
        return null;
    }

    private void updateHologram(@Nonnull Location loc, @Nonnull Consumer<Hologram> consumer) {
        Validate.notNull((Object)loc, (String)"Location must not be null");
        Validate.notNull(consumer, (String)"Callbacks must not be null");
        Runnable runnable = () -> {
            try {
                Hologram hologram = this.getHologram(loc, true);
                if (hologram != null) {
                    consumer.accept(hologram);
                }
            }
            catch (Exception | LinkageError x) {
                SlimefunPlugin.logger().log(Level.SEVERE, "Hologram located at {0}", new BlockPosition(loc));
                SlimefunPlugin.logger().log(Level.SEVERE, "Something went wrong while trying to update this hologram", x);
            }
        };
        if (Bukkit.isPrimaryThread()) {
            runnable.run();
        } else {
            SlimefunPlugin.runSync(runnable);
        }
    }

    public boolean removeHologram(@Nonnull Location loc) {
        Validate.notNull((Object)loc, (String)"Location cannot be null");
        if (Bukkit.isPrimaryThread()) {
            try {
                Hologram hologram = this.getHologram(loc, false);
                if (hologram != null) {
                    this.cache.remove(new BlockPosition(loc));
                    hologram.remove();
                    return true;
                }
                return false;
            }
            catch (Exception | LinkageError x) {
                SlimefunPlugin.logger().log(Level.SEVERE, "Hologram located at {0}", new BlockPosition(loc));
                SlimefunPlugin.logger().log(Level.SEVERE, "Something went wrong while trying to remove this hologram", x);
                return false;
            }
        }
        throw new UnsupportedOperationException("You cannot remove a hologram asynchronously.");
    }

    public void setHologramLabel(@Nonnull Location loc, @Nullable String label) {
        Validate.notNull((Object)loc, (String)"Location must not be null");
        this.updateHologram(loc, hologram -> hologram.setLabel(label));
    }
}

