/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.events;

import io.github.thebusybiscuit.slimefun4.implementation.items.tools.ExplosiveTool;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.Validate;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;

public class ExplosiveToolBreakBlocksEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final ItemStack itemInHand;
    private final ExplosiveTool explosiveTool;
    private final List<Block> blocks;
    private boolean cancelled;

    @ParametersAreNonnullByDefault
    public ExplosiveToolBreakBlocksEvent(Player player, List<Block> blocks, ItemStack item, ExplosiveTool explosiveTool) {
        super(player);
        Validate.notNull(blocks, (String)"Blocks cannot be null");
        Validate.notNull((Object)item, (String)"Item cannot be null");
        Validate.notNull((Object)explosiveTool, (String)"ExplosiveTool cannot be null");
        this.blocks = blocks;
        this.itemInHand = item;
        this.explosiveTool = explosiveTool;
    }

    @Nonnull
    public List<Block> getBlocks() {
        return this.blocks;
    }

    @Nonnull
    public ExplosiveTool getExplosiveTool() {
        return this.explosiveTool;
    }

    @Nonnull
    public ItemStack getItemInHand() {
        return this.itemInHand;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Nonnull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Nonnull
    public HandlerList getHandlers() {
        return ExplosiveToolBreakBlocksEvent.getHandlerList();
    }
}

