/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.events;

import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.Cooler;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;

public class CoolerFeedPlayerEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final Cooler cooler;
    private final ItemStack coolerItem;
    private ItemStack consumedItem;
    private boolean cancelled;

    @ParametersAreNonnullByDefault
    public CoolerFeedPlayerEvent(Player player, Cooler cooler, ItemStack coolerItem, ItemStack consumedItem) {
        super(player);
        this.cooler = cooler;
        this.coolerItem = coolerItem;
        this.consumedItem = consumedItem;
    }

    @Nonnull
    public Cooler getCooler() {
        return this.cooler;
    }

    @Nonnull
    public ItemStack getCoolerItem() {
        return this.coolerItem;
    }

    @Nonnull
    public ItemStack getConsumedItem() {
        return this.consumedItem.clone();
    }

    public void setConsumedItem(@Nonnull ItemStack item) {
        Validate.notNull((Object)item, (String)"The consumed Item cannot be null!");
        Validate.isTrue((boolean)(item.getItemMeta() instanceof PotionMeta), (String)"The item must be a potion!");
        this.consumedItem = item;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Nonnull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Nonnull
    public HandlerList getHandlers() {
        return CoolerFeedPlayerEvent.getHandlerList();
    }
}

