/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.cargo;

import io.github.thebusybiscuit.slimefun4.core.networks.cargo.CargoUtils;
import io.github.thebusybiscuit.slimefun4.implementation.items.cargo.CargoNode;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

class ItemFilter
implements Predicate<ItemStack> {
    private final List<ItemStackWrapper> items = new ArrayList<ItemStackWrapper>(9);
    private boolean rejectOnMatch;
    private boolean checkLore;
    private boolean dirty = false;

    public ItemFilter(@Nonnull Block b) {
        this.update(b);
    }

    public void update(@Nonnull Block b) {
        Config blockData = BlockStorage.getLocationInfo(b.getLocation());
        String id = blockData.getString("id");
        SlimefunItem item = SlimefunItem.getByID(id);
        BlockMenu menu = BlockStorage.getInventory(b.getLocation());
        if (!(item instanceof CargoNode) || menu == null) {
            this.clear(false);
        } else if (((CargoNode)((Object)item)).hasItemFilter()) {
            this.clear(true);
        } else {
            this.items.clear();
            this.checkLore = Objects.equals(blockData.getString("filter-lore"), "true");
            this.rejectOnMatch = !Objects.equals(blockData.getString("filter-type"), "whitelist");
            for (int slot : CargoUtils.getFilteringSlots()) {
                ItemStack stack = menu.getItemInSlot(slot);
                if (stack == null || stack.getType() == Material.AIR) continue;
                this.items.add(new ItemStackWrapper(stack));
            }
        }
        this.dirty = false;
    }

    private void clear(boolean rejectOnMatch) {
        this.items.clear();
        this.checkLore = false;
        this.rejectOnMatch = rejectOnMatch;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public boolean test(@Nonnull ItemStack item) {
        if (this.items.isEmpty()) {
            return this.rejectOnMatch;
        }
        int potentialMatches = 0;
        for (ItemStackWrapper stack : this.items) {
            if (stack.getType() != item.getType()) continue;
            ++potentialMatches;
        }
        if (potentialMatches == 0) {
            return this.rejectOnMatch;
        }
        ItemStack subject = potentialMatches == 1 ? item : new ItemStackWrapper(item);
        for (ItemStackWrapper stack : this.items) {
            if (!SlimefunUtils.isItemSimilar(subject, stack, this.checkLore, false)) continue;
            return !this.rejectOnMatch;
        }
        return this.rejectOnMatch;
    }
}

