/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.core.categories.SeasonalCategory;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Category
implements Keyed {
    private SlimefunAddon addon;
    protected final List<SlimefunItem> items = new ArrayList<SlimefunItem>();
    protected final NamespacedKey key;
    protected final ItemStack item;
    protected final int tier;

    @ParametersAreNonnullByDefault
    public Category(NamespacedKey key, ItemStack item) {
        this(key, item, 3);
    }

    @ParametersAreNonnullByDefault
    public Category(NamespacedKey key, ItemStack item, int tier) {
        Validate.notNull((Object)key, (String)"A Category's NamespacedKey must not be null!");
        Validate.notNull((Object)item, (String)"A Category's ItemStack must not be null!");
        this.item = item;
        this.key = key;
        ItemMeta meta = item.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        this.item.setItemMeta(meta);
        this.tier = tier;
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    public void register(@Nonnull SlimefunAddon addon) {
        Validate.notNull((Object)addon, (String)"The Addon cannot be null");
        this.addon = addon;
        SlimefunPlugin.getRegistry().getCategories().add(this);
        Collections.sort(SlimefunPlugin.getRegistry().getCategories(), Comparator.comparingInt(Category::getTier));
    }

    @Nullable
    public final SlimefunAddon getAddon() {
        return this.addon;
    }

    public void add(@Nonnull SlimefunItem item) {
        Validate.notNull((Object)item, (String)"Cannot add null Items to a Category!");
        if (this.items.contains(item)) {
            return;
        }
        this.items.add(item);
    }

    public void remove(@Nonnull SlimefunItem item) {
        Validate.notNull((Object)item, (String)"Cannot remove null from a Category!");
        this.items.remove(item);
    }

    @Nonnull
    public ItemStack getItem(@Nonnull Player p) {
        return new CustomItem(this.item, meta -> {
            String name = SlimefunPlugin.getLocalization().getCategoryName(p, this.getKey());
            if (name == null) {
                name = this.item.getItemMeta().getDisplayName();
            }
            if (this instanceof SeasonalCategory) {
                meta.setDisplayName(ChatColor.GOLD + name);
            } else {
                meta.setDisplayName(ChatColor.YELLOW + name);
            }
            meta.setLore(Arrays.asList("", ChatColor.GRAY + "\u21e8 " + ChatColor.GREEN + SlimefunPlugin.getLocalization().getMessage(p, "guide.tooltips.open-category")));
        });
    }

    @Nonnull
    public String getUnlocalizedName() {
        return ChatColor.stripColor((String)this.item.getItemMeta().getDisplayName());
    }

    @Nonnull
    public String getDisplayName(@Nonnull Player p) {
        String localized = SlimefunPlugin.getLocalization().getCategoryName(p, this.getKey());
        if (localized != null) {
            return localized;
        }
        return this.getUnlocalizedName();
    }

    @Nonnull
    public List<SlimefunItem> getItems() {
        return this.items;
    }

    public boolean contains(SlimefunItem item) {
        return item != null && this.items.contains(item);
    }

    public int getTier() {
        return this.tier;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {" + this.key + ",tier=" + this.tier + "}";
    }

    public boolean isHidden(@Nonnull Player p) {
        for (SlimefunItem slimefunItem : this.getItems()) {
            if (slimefunItem.isHidden() || slimefunItem.isDisabledIn(p.getWorld())) continue;
            return false;
        }
        return true;
    }

    public boolean isRegistered() {
        return SlimefunPlugin.getRegistry().getCategories().contains(this);
    }
}

