/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.integrations;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.core.researching.Research;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

class PlaceholderAPIIntegration
extends PlaceholderExpansion {
    private final String version;
    private final String author;

    public PlaceholderAPIIntegration(@Nonnull SlimefunPlugin plugin) {
        this.version = plugin.getDescription().getVersion();
        this.author = plugin.getDescription().getAuthors().toString();
    }

    @Nonnull
    public String getIdentifier() {
        return "slimefun";
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    @Nonnull
    public String getAuthor() {
        return this.author;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    private boolean isPlaceholder(@Nullable OfflinePlayer p, boolean requiresProfile, @Nonnull String params, @Nonnull String placeholder) {
        if (requiresProfile) {
            if (p != null && placeholder.equals(params)) {
                PlayerProfile.request(p);
                return true;
            }
            return false;
        }
        return placeholder.equals(params);
    }

    public String onRequest(@Nullable OfflinePlayer p, @Nonnull String params) {
        Optional<PlayerProfile> profile;
        if (this.isPlaceholder(p, true, params, "researches_total_xp_levels_spent")) {
            profile = PlayerProfile.find(p);
            if (profile.isPresent()) {
                Stream stream = profile.get().getResearches().stream();
                return String.valueOf(stream.mapToInt(Research::getCost).sum());
            }
            if (p instanceof Player) {
                return SlimefunPlugin.getLocalization().getMessage((Player)p, "placeholderapi.profile-loading");
            }
        }
        if (this.isPlaceholder(p, true, params, "researches_total_researches_unlocked")) {
            profile = PlayerProfile.find(p);
            if (profile.isPresent()) {
                Set<Research> set = profile.get().getResearches();
                return String.valueOf(set.size());
            }
            if (p instanceof Player) {
                return SlimefunPlugin.getLocalization().getMessage((Player)p, "placeholderapi.profile-loading");
            }
        }
        if (this.isPlaceholder(p, false, params, "researches_total_researches")) {
            return String.valueOf(SlimefunPlugin.getRegistry().getResearches().size());
        }
        if (this.isPlaceholder(p, true, params, "researches_percentage_researches_unlocked")) {
            profile = PlayerProfile.find(p);
            if (profile.isPresent()) {
                Set<Research> set = profile.get().getResearches();
                return String.valueOf((float)Math.round((float)set.size() * 100.0f / (float)SlimefunPlugin.getRegistry().getResearches().size() * 100.0f) / 100.0f);
            }
            if (p instanceof Player) {
                return SlimefunPlugin.getLocalization().getMessage((Player)p, "placeholderapi.profile-loading");
            }
        }
        if (this.isPlaceholder(p, true, params, "researches_title")) {
            profile = PlayerProfile.find(p);
            if (profile.isPresent()) {
                return profile.get().getTitle();
            }
            if (p instanceof Player) {
                return SlimefunPlugin.getLocalization().getMessage((Player)p, "placeholderapi.profile-loading");
            }
        }
        if (this.isPlaceholder(p, false, params, "gps_complexity") && p != null) {
            return String.valueOf(SlimefunPlugin.getGPSNetwork().getNetworkComplexity(p.getUniqueId()));
        }
        if (this.isPlaceholder(p, false, params, "timings_lag")) {
            return SlimefunPlugin.getProfiler().getTime();
        }
        if (this.isPlaceholder(p, false, params, "language") && p instanceof Player) {
            Player player = (Player)p;
            return SlimefunPlugin.getLocalization().getLanguage(player).getName(player);
        }
        return null;
    }
}

