/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api;

import io.github.thebusybiscuit.slimefun4.utils.PatternUtils;
import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;

public enum SlimefunBranch {
    DEVELOPMENT("development build", true),
    STABLE("\"stable\" build", true),
    UNOFFICIAL("Unofficial build", false),
    UNKNOWN("Unofficial build", false);

    private final String name;
    private final boolean official;

    private SlimefunBranch(String name, boolean official) {
        Validate.notNull((Object)name, (String)"The branch name cannot be null");
        this.name = name;
        this.official = official;
        if (!PatternUtils.ASCII.matcher(name).matches()) {
            throw new IllegalStateException("The SlimefunBranch enum contains ILLEGAL CHARACTERS. DO NOT TRANSLATE THIS FILE.");
        }
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isOfficial() {
        return this.official;
    }
}

