/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.materials;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import lombok.NonNull;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;

public final class MaterialConverter {
    private MaterialConverter() {
    }

    public static Optional<Material> getSaplingFromLog(@NonNull Material log) {
        if (log == null) {
            throw new NullPointerException("log is marked non-null but is null");
        }
        if (log.name().equals("CRIMSON_STEM") || log.name().equals("STRIPPED_CRIMSON_STEM")) {
            return Optional.of(Material.CRIMSON_FUNGUS);
        }
        if (log.name().equals("WARPED_STEM") || log.name().equals("STRIPPED_WARPED_STEM")) {
            return Optional.of(Material.WARPED_FUNGUS);
        }
        return MaterialConverter.convert(log, arg_0 -> ((Tag)Tag.LOGS).isTagged(arg_0), type -> type.substring(0, type.lastIndexOf(95)).replace("STRIPPED_", "") + "_SAPLING");
    }

    public static Optional<Material> getSaplingFromLeaves(@NonNull Material leaves) {
        if (leaves == null) {
            throw new NullPointerException("leaves is marked non-null but is null");
        }
        return MaterialConverter.convert(leaves, arg_0 -> ((Tag)Tag.LEAVES).isTagged(arg_0), type -> type.replace("_LEAVES", "_SAPLING"));
    }

    public static Optional<Material> getPlanksFromLog(@NonNull Material log) {
        if (log == null) {
            throw new NullPointerException("log is marked non-null but is null");
        }
        return MaterialConverter.convert(log, arg_0 -> ((Tag)Tag.LOGS).isTagged(arg_0), type -> type.substring(0, type.lastIndexOf(95)).replace("STRIPPED_", "") + "_PLANKS");
    }

    public static Optional<Material> getStrippedFromLog(@NonNull Material log) {
        if (log == null) {
            throw new NullPointerException("log is marked non-null but is null");
        }
        return MaterialConverter.convert(log, type -> Tag.LOGS.isTagged((Keyed)type) && !type.name().startsWith("STRIPPED_"), type -> "STRIPPED_" + type);
    }

    private static Optional<Material> convert(Material type, Predicate<Material> predicate, UnaryOperator<String> converter) {
        if (!predicate.test(type)) {
            return Optional.empty();
        }
        return Optional.ofNullable(Material.getMaterial((String)((String)converter.apply(type.name()))));
    }
}

