/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.Objects.SlimefunItem.machines;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.mrCookieSlime.CSCoreLibPlugin.CSCoreLib;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.InvUtils;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItem;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItemSerializer;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.energy.ChargableBlock;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.api.item_transport.RecipeSorter;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class AutomatedCraftingChamber
extends SlimefunItem {
    private static final int[] border = new int[]{0, 1, 3, 4, 5, 7, 8, 13, 14, 15, 16, 17, 50, 51, 52, 53};
    private static final int[] border_in = new int[]{9, 10, 11, 12, 13, 18, 22, 27, 31, 36, 40, 45, 46, 47, 48, 49};
    private static final int[] border_out = new int[]{23, 24, 25, 26, 32, 35, 41, 42, 43, 44};
    public static Map<String, ItemStack> recipes = new HashMap<String, ItemStack>();

    public AutomatedCraftingChamber(Category category, ItemStack item, String name, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, name, recipeType, recipe);
        new BlockMenuPreset(name, "&6Automated Crafting Chamber"){

            @Override
            public void init() {
                AutomatedCraftingChamber.this.constructMenu(this);
            }

            @Override
            public void newInstance(final BlockMenu menu, final Block b) {
                if (!BlockStorage.hasBlockInfo(b) || BlockStorage.getLocationInfo(b.getLocation(), "enabled") == null || BlockStorage.getLocationInfo(b.getLocation(), "enabled").equals("false")) {
                    menu.replaceExistingItem(6, (ItemStack)new CustomItem(new ItemStack(Material.GUNPOWDER), "&7Enabled: &4\u2718", new String[]{"", "&e> Click to enable this Machine"}));
                    menu.addMenuClickHandler(6, new ChestMenu.MenuClickHandler(){

                        public boolean onClick(Player p, int arg1, ItemStack arg2, ClickAction arg3) {
                            BlockStorage.addBlockInfo(b, "enabled", "true");
                            this.newInstance(menu, b);
                            return false;
                        }
                    });
                } else {
                    menu.replaceExistingItem(6, (ItemStack)new CustomItem(new ItemStack(Material.REDSTONE), "&7Enabled: &2\u2714", new String[]{"", "&e> Click to disable this Machine"}));
                    menu.addMenuClickHandler(6, new ChestMenu.MenuClickHandler(){

                        public boolean onClick(Player p, int arg1, ItemStack arg2, ClickAction arg3) {
                            BlockStorage.addBlockInfo(b, "enabled", "false");
                            this.newInstance(menu, b);
                            return false;
                        }
                    });
                }
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || CSCoreLib.getLib().getProtectionManager().canAccessChest(p.getUniqueId(), b, true);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(BlockMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow.equals((Object)ItemTransportFlow.WITHDRAW)) {
                    return AutomatedCraftingChamber.this.getOutputSlots();
                }
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int slot : AutomatedCraftingChamber.this.getInputSlots()) {
                    if (menu.getItemInSlot(slot) == null) continue;
                    slots.add(slot);
                }
                Collections.sort(slots, new RecipeSorter(menu));
                int[] array = new int[slots.size()];
                for (int i = 0; i < slots.size(); ++i) {
                    array[i] = (Integer)slots.get(i);
                }
                return array;
            }
        };
        AutomatedCraftingChamber.registerBlockHandler(name, new SlimefunBlockHandler(){

            @Override
            public void onPlace(Player p, Block b, SlimefunItem item) {
                BlockStorage.addBlockInfo(b, "enabled", "false");
            }

            @Override
            public boolean onBreak(Player p, Block b, SlimefunItem item, UnregisterReason reason) {
                BlockMenu inv = BlockStorage.getInventory(b);
                if (inv != null) {
                    for (int slot : AutomatedCraftingChamber.this.getInputSlots()) {
                        if (inv.getItemInSlot(slot) == null) continue;
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        inv.replaceExistingItem(slot, null);
                    }
                    for (int slot : AutomatedCraftingChamber.this.getOutputSlots()) {
                        if (inv.getItemInSlot(slot) == null) continue;
                        b.getWorld().dropItemNaturally(b.getLocation(), inv.getItemInSlot(slot));
                        inv.replaceExistingItem(slot, null);
                    }
                }
                return true;
            }
        });
    }

    protected void constructMenu(BlockMenuPreset preset) {
        for (int i : border) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " "), new ChestMenu.MenuClickHandler(){

                public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                    return false;
                }
            });
        }
        for (int i : border_in) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.BLUE_STAINED_GLASS_PANE), " "), new ChestMenu.MenuClickHandler(){

                public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                    return false;
                }
            });
        }
        for (int i : border_out) {
            preset.addItem(i, (ItemStack)new CustomItem(new ItemStack(Material.ORANGE_STAINED_GLASS_PANE), " "), new ChestMenu.MenuClickHandler(){

                public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                    return false;
                }
            });
        }
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == null || cursor.getType() == Material.AIR;
                }
            });
        }
        preset.addItem(2, (ItemStack)new CustomItem(new ItemStack(Material.CRAFTING_TABLE), "&eRecipe", new String[]{"", "&bPut in the Recipe you want to craft", "&4Enhanced Crafting Table Recipes ONLY"}), new ChestMenu.MenuClickHandler(){

            public boolean onClick(Player arg0, int arg1, ItemStack arg2, ClickAction arg3) {
                return false;
            }
        });
    }

    public abstract int getEnergyConsumption();

    public int[] getInputSlots() {
        return new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    }

    public int[] getOutputSlots() {
        return new int[]{33, 34};
    }

    private Inventory inject(Block b) {
        int size = BlockStorage.getInventory(b).toInventory().getSize();
        Inventory inv = Bukkit.createInventory(null, (int)size);
        for (int i = 0; i < size; ++i) {
            inv.setItem(i, (ItemStack)new CustomItem(Material.COMMAND_BLOCK, " &4ALL YOUR PLACEHOLDERS ARE BELONG TO US", 0));
        }
        for (int slot : this.getOutputSlots()) {
            inv.setItem(slot, BlockStorage.getInventory(b).getItemInSlot(slot));
        }
        return inv;
    }

    protected boolean fits(Block b, ItemStack[] items) {
        return this.inject(b).addItem(items).isEmpty();
    }

    protected void pushItems(Block b, ItemStack[] items) {
        Inventory inv = this.inject(b);
        inv.addItem(items);
        for (int slot : this.getOutputSlots()) {
            BlockStorage.getInventory(b).replaceExistingItem(slot, inv.getItem(slot));
        }
    }

    @Override
    public void register(boolean slimefun) {
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, Config data) {
                AutomatedCraftingChamber.this.tick(b);
            }

            @Override
            public void uniqueTick() {
            }

            @Override
            public boolean isSynchronized() {
                return false;
            }
        });
        super.register(slimefun);
    }

    protected void tick(Block b) {
        ItemStack output;
        if (BlockStorage.getLocationInfo(b.getLocation(), "enabled").equals("false")) {
            return;
        }
        if (ChargableBlock.getCharge(b) < this.getEnergyConsumption()) {
            return;
        }
        BlockMenu menu = BlockStorage.getInventory(b);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (int j = 0; j < 9; ++j) {
            ItemStack item;
            if (i > 0) {
                builder.append(" </slot> ");
            }
            if ((item = menu.getItemInSlot(this.getInputSlots()[j])) != null && item.getAmount() == 1) {
                return;
            }
            builder.append(CustomItemSerializer.serialize((ItemStack)item, (CustomItemSerializer.ItemFlag[])new CustomItemSerializer.ItemFlag[]{CustomItemSerializer.ItemFlag.DATA, CustomItemSerializer.ItemFlag.ITEMMETA_DISPLAY_NAME, CustomItemSerializer.ItemFlag.ITEMMETA_LORE, CustomItemSerializer.ItemFlag.MATERIAL}));
            ++i;
        }
        String input = builder.toString();
        if (recipes.containsKey(input) && this.fits(b, new ItemStack[]{output = recipes.get(input).clone()})) {
            this.pushItems(b, new ItemStack[]{output});
            ChargableBlock.addCharge(b, -this.getEnergyConsumption());
            for (int j = 0; j < 9; ++j) {
                if (menu.getItemInSlot(this.getInputSlots()[j]) == null) continue;
                menu.replaceExistingItem(this.getInputSlots()[j], InvUtils.decreaseItem((ItemStack)menu.getItemInSlot(this.getInputSlots()[j]), (int)1));
            }
        }
    }
}

