/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.geo;

import io.github.thebusybiscuit.slimefun4.api.geo.GEOResource;
import io.github.thebusybiscuit.slimefun4.core.attributes.HologramOwner;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalInt;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class GEOMiner
extends AContainer
implements RecipeDisplayItem,
HologramOwner {
    private static final int[] BORDER = new int[]{0, 1, 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 26, 27, 35, 36, 44, 45, 53};
    private static final int[] OUTPUT_BORDER = new int[]{19, 20, 21, 22, 23, 24, 25, 28, 34, 37, 43, 46, 47, 48, 49, 50, 51, 52};
    private static final int[] OUTPUT_SLOTS = new int[]{29, 30, 31, 32, 33, 38, 39, 40, 41, 42};
    private static final int PROCESSING_TIME = 14;

    public GEOMiner(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.addItemHandler(this.onPlace());
        GEOMiner.registerBlockHandler(this.getId(), (p, b, stack, reason) -> {
            this.removeHologram(b);
            BlockMenu inv = BlockStorage.getInventory(b);
            if (inv != null) {
                inv.dropItems(b.getLocation(), this.getOutputSlots());
            }
            progress.remove(b);
            processing.remove(b);
            return true;
        });
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(false){

            @Override
            public void onPlayerPlace(BlockPlaceEvent e) {
                GEOMiner.this.updateHologram(e.getBlock(), "&7Idling...");
            }
        };
    }

    @Override
    public String getMachineIdentifier() {
        return "GEO_MINER";
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.DIAMOND_PICKAXE);
    }

    @Override
    public int[] getInputSlots() {
        return new int[0];
    }

    @Override
    public int[] getOutputSlots() {
        return OUTPUT_SLOTS;
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        LinkedList<ItemStack> displayRecipes = new LinkedList<ItemStack>();
        for (GEOResource resource : SlimefunPlugin.getRegistry().getGEOResources().values()) {
            if (!resource.isObtainableFromGEOMiner()) continue;
            displayRecipes.add(new CustomItem(resource.getItem(), ChatColor.RESET + resource.getName(), new String[0]));
        }
        return displayRecipes;
    }

    @Override
    public String getLabelLocalPath() {
        return "guide.tooltips.recipes.miner";
    }

    @Override
    protected void constructMenu(BlockMenuPreset preset) {
        for (int i : BORDER) {
            preset.addItem(i, new CustomItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : OUTPUT_BORDER) {
            preset.addItem(i, new CustomItem(Material.ORANGE_STAINED_GLASS_PANE, " ", new String[0]), (p, slot, item, action) -> false);
        }
        preset.addItem(4, new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]), (p, slot, item, action) -> false);
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, new ChestMenu.AdvancedMenuClickHandler(){

                @Override
                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                @Override
                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == null || cursor.getType() == Material.AIR;
                }
            });
        }
    }

    @Override
    protected void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory(b);
        if (this.isProcessing(b)) {
            int timeleft = (Integer)progress.get(b);
            if (timeleft > 0) {
                ChestMenuUtils.updateProgressbar(inv, 4, timeleft, ((MachineRecipe)processing.get(b)).getTicks(), this.getProgressBar());
                if (this.getCharge(b.getLocation()) < this.getEnergyConsumption()) {
                    return;
                }
                this.removeCharge(b.getLocation(), this.getEnergyConsumption());
                progress.put(b, timeleft - 1);
            } else {
                inv.replaceExistingItem(4, new CustomItem(Material.BLACK_STAINED_GLASS_PANE, " ", new String[0]));
                inv.pushItem(((MachineRecipe)processing.get(b)).getOutput()[0], this.getOutputSlots());
                progress.remove(b);
                processing.remove(b);
            }
        } else if (!BlockStorage.hasChunkInfo(b.getWorld(), b.getX() >> 4, b.getZ() >> 4)) {
            this.updateHologram(b, "&4GEO-Scan required!");
        } else {
            this.start(b, inv);
        }
    }

    private void start(Block b, BlockMenu inv) {
        for (GEOResource resource : SlimefunPlugin.getRegistry().getGEOResources().values()) {
            if (!resource.isObtainableFromGEOMiner()) continue;
            OptionalInt optional = SlimefunPlugin.getGPSNetwork().getResourceManager().getSupplies(resource, b.getWorld(), b.getX() >> 4, b.getZ() >> 4);
            if (!optional.isPresent()) {
                this.updateHologram(b, "&4GEO-Scan required!");
                return;
            }
            int supplies = optional.getAsInt();
            if (supplies <= 0) continue;
            MachineRecipe r = new MachineRecipe(14 / this.getSpeed(), new ItemStack[0], new ItemStack[]{resource.getItem().clone()});
            if (!inv.fits(r.getOutput()[0], this.getOutputSlots())) {
                return;
            }
            processing.put(b, r);
            progress.put(b, r.getTicks());
            SlimefunPlugin.getGPSNetwork().getResourceManager().setSupplies(resource, b.getWorld(), b.getX() >> 4, b.getZ() >> 4, supplies - 1);
            this.updateHologram(b, "&7Mining: &r" + resource.getName());
            return;
        }
        this.updateHologram(b, "&7Finished");
    }
}

