/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.profiler;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;

public enum PerformanceRating implements Predicate<Float>
{
    UNKNOWN(ChatColor.WHITE, -1.0f),
    GOOD(ChatColor.DARK_GREEN, 10.0f),
    FINE(ChatColor.DARK_GREEN, 20.0f),
    OKAY(ChatColor.GREEN, 30.0f),
    MODERATE(ChatColor.YELLOW, 55.0f),
    SEVERE(ChatColor.RED, 85.0f),
    HURTFUL(ChatColor.DARK_RED, 500.0f),
    BAD(ChatColor.DARK_RED, Float.MAX_VALUE);

    private final ChatColor color;
    private final float threshold;

    private PerformanceRating(ChatColor color, float threshold) {
        Validate.notNull((Object)color, (String)"Color cannot be null");
        this.color = color;
        this.threshold = threshold;
    }

    @Override
    public boolean test(@Nullable Float value) {
        if (value == null) {
            return this.threshold < 0.0f;
        }
        return value.floatValue() <= this.threshold;
    }

    @Nonnull
    public ChatColor getColor() {
        return this.color;
    }
}

