/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api;

import javax.annotation.Nonnull;
import org.apache.commons.lang.Validate;

public enum MinecraftVersion {
    MINECRAFT_1_14(14, "1.14.x"),
    MINECRAFT_1_15(15, "1.15.x"),
    MINECRAFT_1_16(16, "1.16.x"),
    UNKNOWN("Unknown", true),
    UNIT_TEST("Unit Test Environment", true);

    private final String name;
    private final boolean virtual;
    private final int majorVersion;

    private MinecraftVersion(int majorVersion, String name) {
        this.name = name;
        this.majorVersion = majorVersion;
        this.virtual = false;
    }

    private MinecraftVersion(String name, boolean virtual) {
        this.name = name;
        this.majorVersion = 0;
        this.virtual = virtual;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public boolean isMinecraftVersion(int minecraftVersion) {
        return !this.isVirtual() && this.majorVersion == minecraftVersion;
    }

    public boolean isAtLeast(@Nonnull MinecraftVersion version) {
        Validate.notNull((Object)((Object)version), (String)"A Minecraft version cannot be null!");
        if (this == UNKNOWN) {
            return false;
        }
        return this.ordinal() >= version.ordinal();
    }

    public boolean isBefore(@Nonnull MinecraftVersion version) {
        Validate.notNull((Object)((Object)version), (String)"A Minecraft version cannot be null!");
        if (this == UNKNOWN) {
            return true;
        }
        return version.ordinal() > this.ordinal();
    }
}

