/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.cargo;

import io.github.thebusybiscuit.slimefun4.api.network.NetworkComponent;
import io.github.thebusybiscuit.slimefun4.core.attributes.HologramOwner;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.AbstractItemNetwork;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.CargoNetworkTask;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class CargoNet
extends AbstractItemNetwork
implements HologramOwner {
    private static final int RANGE = 5;
    private static final int TICK_DELAY = SlimefunPlugin.getCfg().getInt("networks.cargo-ticker-delay");
    private final Set<Location> inputNodes = new HashSet<Location>();
    private final Set<Location> outputNodes = new HashSet<Location>();
    protected final Map<Location, Integer> roundRobin = new HashMap<Location, Integer>();
    private int tickDelayThreshold = 0;

    public static CargoNet getNetworkFromLocation(@Nonnull Location l) {
        return SlimefunPlugin.getNetworkManager().getNetworkFromLocation(l, CargoNet.class).orElse(null);
    }

    public static CargoNet getNetworkFromLocationOrCreate(@Nonnull Location l) {
        Optional<CargoNet> cargoNetwork = SlimefunPlugin.getNetworkManager().getNetworkFromLocation(l, CargoNet.class);
        if (cargoNetwork.isPresent()) {
            return cargoNetwork.get();
        }
        CargoNet network = new CargoNet(l);
        SlimefunPlugin.getNetworkManager().registerNetwork(network);
        return network;
    }

    protected CargoNet(@Nonnull Location l) {
        super(l);
    }

    @Override
    public int getRange() {
        return 5;
    }

    @Override
    public NetworkComponent classifyLocation(@Nonnull Location l) {
        String id = BlockStorage.checkID(l);
        if (id == null) {
            return null;
        }
        switch (id) {
            case "CARGO_MANAGER": {
                return NetworkComponent.REGULATOR;
            }
            case "CARGO_NODE": {
                return NetworkComponent.CONNECTOR;
            }
            case "CARGO_NODE_INPUT": 
            case "CARGO_NODE_OUTPUT": 
            case "CARGO_NODE_OUTPUT_ADVANCED": 
            case "CT_IMPORT_BUS": 
            case "CT_EXPORT_BUS": 
            case "CHEST_TERMINAL": {
                return NetworkComponent.TERMINUS;
            }
        }
        return null;
    }

    @Override
    public void onClassificationChange(Location l, NetworkComponent from, NetworkComponent to) {
        this.connectorCache.remove(l);
        if (from == NetworkComponent.TERMINUS) {
            this.inputNodes.remove(l);
            this.outputNodes.remove(l);
            this.terminals.remove(l);
            this.imports.remove(l);
            this.exports.remove(l);
        }
        if (to == NetworkComponent.TERMINUS) {
            String id;
            switch (id = BlockStorage.checkID(l)) {
                case "CARGO_NODE_INPUT": {
                    this.inputNodes.add(l);
                    break;
                }
                case "CARGO_NODE_OUTPUT": 
                case "CARGO_NODE_OUTPUT_ADVANCED": {
                    this.outputNodes.add(l);
                    break;
                }
                case "CHEST_TERMINAL": {
                    this.terminals.add(l);
                    break;
                }
                case "CT_IMPORT_BUS": {
                    this.imports.add(l);
                    break;
                }
                case "CT_EXPORT_BUS": {
                    this.exports.add(l);
                    break;
                }
            }
        }
    }

    public void tick(Block b) {
        if (!this.regulator.equals((Object)b.getLocation())) {
            this.updateHologram(b, "&4Multiple Cargo Regulators connected");
            return;
        }
        super.tick();
        if (this.connectorNodes.isEmpty() && this.terminusNodes.isEmpty()) {
            this.updateHologram(b, "&cNo Cargo Nodes found");
        } else {
            this.updateHologram(b, "&7Status: &a&lONLINE");
            if (this.tickDelayThreshold < TICK_DELAY) {
                ++this.tickDelayThreshold;
                return;
            }
            this.tickDelayThreshold = 0;
            HashSet<Location> chestTerminalInputs = new HashSet<Location>();
            HashSet<Location> chestTerminalOutputs = new HashSet<Location>();
            Map<Location, Integer> inputs = this.mapInputNodes(chestTerminalInputs);
            Map<Integer, List<Location>> outputs = this.mapOutputNodes(chestTerminalOutputs);
            if (BlockStorage.getLocationInfo(b.getLocation(), "visualizer") == null) {
                this.display();
            }
            SlimefunPlugin.getProfiler().scheduleEntries((this.terminals.isEmpty() ? 1 : 2) + inputs.size());
            CargoNetworkTask runnable = new CargoNetworkTask(this, inputs, outputs, chestTerminalInputs, chestTerminalOutputs);
            SlimefunPlugin.runSync(runnable);
        }
    }

    private Map<Location, Integer> mapInputNodes(Set<Location> chestTerminalNodes) {
        HashMap<Location, Integer> inputs = new HashMap<Location, Integer>();
        for (Location node : this.inputNodes) {
            int frequency = CargoNet.getFrequency(node);
            if (frequency == 16) {
                chestTerminalNodes.add(node);
                continue;
            }
            if (frequency < 0 || frequency >= 16) continue;
            inputs.put(node, frequency);
        }
        return inputs;
    }

    private Map<Integer, List<Location>> mapOutputNodes(Set<Location> chestTerminalOutputs) {
        HashMap<Integer, List<Location>> output = new HashMap<Integer, List<Location>>();
        LinkedList<Location> list = new LinkedList<Location>();
        int lastFrequency = -1;
        for (Location node : this.outputNodes) {
            int frequency = CargoNet.getFrequency(node);
            if (frequency == 16) {
                chestTerminalOutputs.add(node);
                continue;
            }
            if (frequency != lastFrequency && lastFrequency != -1) {
                output.merge(lastFrequency, list, (prev, next) -> {
                    prev.addAll(next);
                    return prev;
                });
                list = new LinkedList();
            }
            list.add(node);
            lastFrequency = frequency;
        }
        if (!list.isEmpty()) {
            output.merge(lastFrequency, list, (prev, next) -> {
                prev.addAll(next);
                return prev;
            });
        }
        return output;
    }

    private static int getFrequency(Location node) {
        try {
            String str = BlockStorage.getLocationInfo(node).getString("frequency");
            return str == null ? 0 : Integer.parseInt(str);
        }
        catch (Exception x) {
            SlimefunPlugin.logger().log(Level.SEVERE, x, () -> "An Error occurred while parsing a Cargo Node Frequency (" + node.getWorld().getName() + " - " + node.getBlockX() + "," + node.getBlockY() + "," + node.getBlockZ() + ")");
            return 0;
        }
    }
}

