/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.elevator;

import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import io.github.thebusybiscuit.slimefun4.implementation.items.elevator.ElevatorFloor;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChatUtils;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class ElevatorPlate
extends SimpleSlimefunItem<BlockUseHandler> {
    private static final String DATA_KEY = "floor";
    private static final int GUI_SIZE = 27;
    private final Set<UUID> users = new HashSet<UUID>();

    @ParametersAreNonnullByDefault
    public ElevatorPlate(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe, ItemStack recipeOutput) {
        super(category, item, recipeType, recipe, recipeOutput);
        this.addItemHandler(this.onPlace());
    }

    @Nonnull
    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(false){

            @Override
            public void onPlayerPlace(BlockPlaceEvent e) {
                Block b = e.getBlock();
                BlockStorage.addBlockInfo(b, ElevatorPlate.DATA_KEY, ChatColor.WHITE + "Floor #0");
                BlockStorage.addBlockInfo(b, "owner", e.getPlayer().getUniqueId().toString());
            }
        };
    }

    @Override
    @Nonnull
    public BlockUseHandler getItemHandler() {
        return e -> {
            Block b = e.getClickedBlock().get();
            if (BlockStorage.getLocationInfo(b.getLocation(), "owner").equals(e.getPlayer().getUniqueId().toString())) {
                this.openEditor(e.getPlayer(), b);
            }
        };
    }

    @Nonnull
    public List<ElevatorFloor> getFloors(@Nonnull Block b) {
        LinkedList<ElevatorFloor> floors = new LinkedList<ElevatorFloor>();
        int index = 0;
        for (int y = 0; y < b.getWorld().getMaxHeight(); ++y) {
            if (y == b.getY()) {
                String name = ChatColors.color(BlockStorage.getLocationInfo(b.getLocation(), DATA_KEY));
                floors.addFirst(new ElevatorFloor(name, index, b));
                ++index;
                continue;
            }
            Block block = b.getWorld().getBlockAt(b.getX(), y, b.getZ());
            if (block.getType() != this.getItem().getType() || !BlockStorage.check(block, this.getId())) continue;
            String name = ChatColors.color(BlockStorage.getLocationInfo(block.getLocation(), DATA_KEY));
            floors.addFirst(new ElevatorFloor(name, index, block));
            ++index;
        }
        return floors;
    }

    @ParametersAreNonnullByDefault
    public void openInterface(Player p, Block b) {
        if (this.users.remove(p.getUniqueId())) {
            return;
        }
        List<ElevatorFloor> floors = this.getFloors(b);
        if (floors.size() < 2) {
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.ELEVATOR.no-destinations", true);
        } else {
            this.openFloorSelector(b, floors, p, 1);
        }
    }

    @ParametersAreNonnullByDefault
    private void openFloorSelector(Block b, List<ElevatorFloor> floors, Player p, int page) {
        ChestMenu menu = new ChestMenu(SlimefunPlugin.getLocalization().getMessage(p, "machines.ELEVATOR.pick-a-floor"));
        menu.setEmptySlotsClickable(false);
        int index = 27 * (page - 1);
        for (int i = 0; i < Math.min(27, floors.size() - index); ++i) {
            ElevatorFloor floor = floors.get(index + i);
            if (floor.getAltitude() == b.getY()) {
                menu.addItem(i, (ItemStack)new CustomItem(Material.COMPASS, ChatColor.GRAY.toString() + floor.getNumber() + ". " + ChatColor.BLACK + floor.getName(), SlimefunPlugin.getLocalization().getMessage(p, "machines.ELEVATOR.current-floor") + ' ' + ChatColor.WHITE + floor.getName()), ChestMenuUtils.getEmptyClickHandler());
                continue;
            }
            menu.addItem(i, (ItemStack)new CustomItem(Material.PAPER, ChatColor.GRAY.toString() + floor.getNumber() + ". " + ChatColor.BLACK + floor.getName(), SlimefunPlugin.getLocalization().getMessage(p, "machines.ELEVATOR.click-to-teleport") + ' ' + ChatColor.WHITE + floor.getName()), (player, slot, itemStack, clickAction) -> {
                this.teleport(player, floor);
                return false;
            });
        }
        int pages = 1 + floors.size() / 27;
        for (int i = 27; i < 36; ++i) {
            if (i == 29 && pages > 1 && page != 1) {
                menu.addItem(i, ChestMenuUtils.getPreviousButton(p, page, pages), (player, i1, itemStack, clickAction) -> {
                    this.openFloorSelector(b, floors, p, page - 1);
                    return false;
                });
                continue;
            }
            if (i == 33 && pages > 1 && page != pages) {
                menu.addItem(i, ChestMenuUtils.getNextButton(p, page, pages), (player, i1, itemStack, clickAction) -> {
                    this.openFloorSelector(b, floors, p, page + 1);
                    return false;
                });
                continue;
            }
            menu.addItem(i, ChestMenuUtils.getBackground(), (player, i1, itemStack, clickAction) -> false);
        }
        menu.open(new Player[]{p});
    }

    @ParametersAreNonnullByDefault
    private void teleport(Player player, ElevatorFloor floor) {
        SlimefunPlugin.runSync(() -> {
            this.users.add(player.getUniqueId());
            float yaw = player.getEyeLocation().getYaw() + 180.0f;
            if (yaw > 180.0f) {
                yaw = -180.0f + (yaw - 180.0f);
            }
            Location loc = floor.getLocation();
            Location destination = new Location(player.getWorld(), loc.getX() + 0.5, loc.getY() + 0.4, loc.getZ() + 0.5, yaw, player.getEyeLocation().getPitch());
            PaperLib.teleportAsync((Entity)player, destination).thenAccept(teleported -> {
                if (teleported.booleanValue()) {
                    player.sendTitle(ChatColor.WHITE + ChatColors.color(floor.getName()), null, 20, 60, 20);
                }
            });
        });
    }

    @ParametersAreNonnullByDefault
    public void openEditor(Player p, Block b) {
        ChestMenu menu = new ChestMenu("Elevator Settings");
        menu.addItem(4, (ItemStack)new CustomItem(Material.NAME_TAG, "&7Floor Name &e(Click to edit)", "", ChatColor.WHITE + ChatColors.color(BlockStorage.getLocationInfo(b.getLocation(), DATA_KEY))));
        menu.addMenuClickHandler(4, (pl, slot, item, action) -> {
            pl.closeInventory();
            pl.sendMessage("");
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.ELEVATOR.enter-name");
            pl.sendMessage("");
            ChatUtils.awaitInput(pl, message -> {
                BlockStorage.addBlockInfo(b, DATA_KEY, message.replace('\u00a7', '&'));
                pl.sendMessage("");
                SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.ELEVATOR.named", msg -> msg.replace("%floor%", (CharSequence)message));
                pl.sendMessage("");
                this.openEditor(pl, b);
            });
            return false;
        });
        menu.open(new Player[]{p});
    }
}

