/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.inventory;

import java.lang.reflect.Method;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.reflection.ReflectionUtils;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public final class ItemUtils {
    private static Method copy;
    private static Method getName;
    private static Method toString;

    private ItemUtils() {
    }

    public static String getItemName(ItemStack item) {
        if (item == null) {
            return "null";
        }
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            return item.getItemMeta().getDisplayName();
        }
        try {
            Object instance = copy.invoke(null, item);
            return (String)toString.invoke(getName.invoke(instance, new Object[0]), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public static boolean canStack(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.getType() != b.getType()) {
            return false;
        }
        if (a.hasItemMeta() != b.hasItemMeta()) {
            return false;
        }
        if (a.hasItemMeta()) {
            ItemMeta bMeta;
            ItemMeta aMeta = a.getItemMeta();
            if (aMeta instanceof Damageable != (bMeta = b.getItemMeta()) instanceof Damageable) {
                return false;
            }
            if (aMeta instanceof Damageable && ((Damageable)aMeta).getDamage() != ((Damageable)bMeta).getDamage()) {
                return false;
            }
            if (aMeta instanceof LeatherArmorMeta != bMeta instanceof LeatherArmorMeta) {
                return false;
            }
            if (aMeta instanceof LeatherArmorMeta && !((LeatherArmorMeta)aMeta).getColor().equals((Object)((LeatherArmorMeta)bMeta).getColor())) {
                return false;
            }
            if (!ReflectionUtils.isVersion("v1_13_")) {
                if (aMeta.hasCustomModelData() != bMeta.hasCustomModelData()) {
                    return false;
                }
                if (aMeta.hasCustomModelData() && aMeta.getCustomModelData() != bMeta.getCustomModelData()) {
                    return false;
                }
            }
            if (!aMeta.getEnchants().equals(bMeta.getEnchants())) {
                return false;
            }
            if (aMeta.hasDisplayName() != bMeta.hasDisplayName()) {
                return false;
            }
            if (aMeta.hasDisplayName() && !aMeta.getDisplayName().equals(bMeta.getDisplayName())) {
                return false;
            }
            if (aMeta.hasLore() != bMeta.hasLore()) {
                return false;
            }
            if (aMeta.hasLore()) {
                if (aMeta.getLore().size() != bMeta.getLore().size()) {
                    return false;
                }
                for (int i = 0; i < aMeta.getLore().size(); ++i) {
                    if (((String)aMeta.getLore().get(i)).equals(bMeta.getLore().get(i))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void damageItem(@NonNull ItemStack item, boolean ignoreEnchantments) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        ItemUtils.damageItem(item, 1, ignoreEnchantments);
    }

    public static void damageItem(@NonNull ItemStack item, int damage, boolean ignoreEnchantments) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (item.getType() != Material.AIR && item.getAmount() > 0) {
            ItemMeta meta;
            Damageable damageable;
            int remove = damage;
            if (!ignoreEnchantments && item.getEnchantments().containsKey(Enchantment.DURABILITY)) {
                int level = item.getEnchantmentLevel(Enchantment.DURABILITY);
                for (int i = 0; i < damage; ++i) {
                    if (!(Math.random() * 100.0 <= (double)(60 + Math.floorDiv(40, level + 1)))) continue;
                    --remove;
                }
            }
            if ((damageable = (Damageable)(meta = item.getItemMeta())).getDamage() + remove > item.getType().getMaxDurability()) {
                item.setAmount(0);
            } else {
                damageable.setDamage(damageable.getDamage() + remove);
                item.setItemMeta(meta);
            }
        }
    }

    public static void consumeItem(@NonNull ItemStack item, boolean replaceConsumables) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        ItemUtils.consumeItem(item, 1, replaceConsumables);
    }

    public static void consumeItem(@NonNull ItemStack item, int amount, boolean replaceConsumables) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (item.getType() != Material.AIR && item.getAmount() > 0) {
            if (replaceConsumables) {
                switch (item.getType()) {
                    case POTION: 
                    case DRAGON_BREATH: 
                    case HONEY_BOTTLE: {
                        item.setType(Material.GLASS_BOTTLE);
                        item.setAmount(1);
                        return;
                    }
                    case WATER_BUCKET: 
                    case LAVA_BUCKET: 
                    case MILK_BUCKET: {
                        item.setType(Material.BUCKET);
                        item.setAmount(1);
                        return;
                    }
                }
            }
            if (item.getAmount() <= amount) {
                item.setAmount(0);
            } else {
                item.setAmount(item.getAmount() - amount);
            }
        }
    }

    static {
        try {
            copy = ReflectionUtils.getOBCClass("inventory.CraftItemStack").getMethod("asNMSCopy", ItemStack.class);
            getName = ReflectionUtils.getMethod(ReflectionUtils.getNMSClass("ItemStack"), "getName");
            toString = ReflectionUtils.getMethod(ReflectionUtils.getNMSClass("IChatBaseComponent"), "getString");
        }
        catch (Exception x) {
            System.err.println("Perhaps you forgot to shade CS-CoreLib's \"reflection\" package?");
            x.printStackTrace();
        }
    }
}

