/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.api.events.CoolerFeedPlayerEvent;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerBackpack;
import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.backpacks.Cooler;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class CoolerListener
implements Listener {
    private final SlimefunPlugin plugin;
    private final Cooler cooler;

    public CoolerListener(@Nonnull SlimefunPlugin plugin, @Nonnull Cooler cooler) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.plugin = plugin;
        this.cooler = cooler;
    }

    @EventHandler
    public void onHungerLoss(FoodLevelChangeEvent e) {
        if (e.getEntity() instanceof Player) {
            Player p = (Player)e.getEntity();
            if (e.getFoodLevel() < p.getFoodLevel()) {
                this.checkAndConsume(p);
            }
        }
    }

    @EventHandler
    public void onHungerDamage(EntityDamageEvent e) {
        if (e.getEntity() instanceof Player && e.getCause() == EntityDamageEvent.DamageCause.STARVATION) {
            this.checkAndConsume((Player)e.getEntity());
        }
    }

    private void checkAndConsume(@Nonnull Player p) {
        if (this.cooler == null || this.cooler.isDisabled()) {
            return;
        }
        for (ItemStack item : p.getInventory().getContents()) {
            if (!this.cooler.isItem(item)) continue;
            if (Slimefun.hasUnlocked(p, this.cooler, true)) {
                this.takeJuiceFromCooler(p, item);
                continue;
            }
            return;
        }
    }

    private void takeJuiceFromCooler(@Nonnull Player p, @Nonnull ItemStack cooler) {
        PlayerProfile.getBackpack(cooler, backpack -> {
            if (backpack != null) {
                SlimefunPlugin.runSync(() -> this.consumeJuice(p, cooler, (PlayerBackpack)backpack));
            }
        });
    }

    private boolean consumeJuice(@Nonnull Player p, @Nonnull ItemStack coolerItem, @Nonnull PlayerBackpack backpack) {
        Inventory inv = backpack.getInventory();
        int slot = -1;
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack == null || stack.getType() != Material.POTION || !stack.hasItemMeta() || !stack.getItemMeta().hasDisplayName()) continue;
            slot = i;
            break;
        }
        if (slot >= 0) {
            ItemStack item = inv.getItem(slot);
            CoolerFeedPlayerEvent event = new CoolerFeedPlayerEvent(p, this.cooler, coolerItem, item);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                PotionMeta im = (PotionMeta)event.getConsumedItem().getItemMeta();
                for (PotionEffect effect : im.getCustomEffects()) {
                    p.addPotionEffect(effect);
                }
                p.setSaturation(6.0f);
                p.playSound(p.getLocation(), Sound.ENTITY_GENERIC_DRINK, 1.0f, 1.0f);
                inv.setItem(slot, null);
                backpack.markDirty();
                return true;
            }
            return false;
        }
        return false;
    }
}

