/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.attributes;

import io.github.thebusybiscuit.slimefun4.core.attributes.ItemAttribute;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

@FunctionalInterface
public interface DamageableItem
extends ItemAttribute {
    public boolean isDamageable();

    default public void damageItem(@Nonnull Player p, @Nullable ItemStack item) {
        if (this.isDamageable() && item != null && item.getType() != Material.AIR && item.getAmount() > 0) {
            int unbreakingLevel = item.getEnchantmentLevel(Enchantment.DURABILITY);
            if (unbreakingLevel > 0 && Math.random() * 100.0 <= (double)(60 + Math.floorDiv(40, unbreakingLevel + 1))) {
                return;
            }
            ItemMeta meta = item.getItemMeta();
            Damageable damageable = (Damageable)meta;
            if (damageable.getDamage() >= item.getType().getMaxDurability()) {
                p.playSound(p.getEyeLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                item.setAmount(0);
            } else {
                damageable.setDamage(damageable.getDamage() + 1);
                item.setItemMeta(meta);
            }
        }
    }
}

