/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.categories;

import io.github.thebusybiscuit.slimefun4.api.player.PlayerProfile;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.apache.commons.lang.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class LockedCategory
extends Category {
    private final NamespacedKey[] keys;
    private final Set<Category> parents = new HashSet<Category>();

    @ParametersAreNonnullByDefault
    public LockedCategory(NamespacedKey key, ItemStack item, NamespacedKey ... parents) {
        this(key, item, 3, parents);
    }

    @ParametersAreNonnullByDefault
    public LockedCategory(NamespacedKey key, ItemStack item, int tier, NamespacedKey ... parents) {
        super(key, item, tier);
        Validate.noNullElements((Object[])parents, (String)"A LockedCategory must not have any 'null' parents!");
        this.keys = parents;
    }

    @Override
    public void register() {
        super.register();
        ArrayList<NamespacedKey> namespacedKeys = new ArrayList<NamespacedKey>();
        for (NamespacedKey key : this.keys) {
            if (key == null) continue;
            namespacedKeys.add(key);
        }
        for (Category category : SlimefunPlugin.getRegistry().getCategories()) {
            if (!namespacedKeys.remove(category.getKey())) continue;
            this.addParent(category);
        }
        for (NamespacedKey key : namespacedKeys) {
            SlimefunPlugin.logger().log(Level.INFO, "Parent \"{0}\" for Category \"{1}\" was not found, probably just disabled.", new Object[]{key, this.getKey()});
        }
    }

    @Nonnull
    public Set<Category> getParents() {
        return this.parents;
    }

    public void addParent(Category category) {
        if (category == this || category == null) {
            throw new IllegalArgumentException("Category '" + this.item.getItemMeta().getDisplayName() + "' cannot be a parent of itself or have a 'null' parent.");
        }
        this.parents.add(category);
    }

    public void removeParent(@Nonnull Category category) {
        this.parents.remove(category);
    }

    public boolean hasUnlocked(@Nonnull Player p, @Nonnull PlayerProfile profile) {
        for (Category category : this.parents) {
            for (SlimefunItem item : category.getItems()) {
                if (!Slimefun.isEnabled(p, item, false) || !Slimefun.hasPermission(p, item, false) || profile.hasUnlocked(item.getResearch())) continue;
                return false;
            }
        }
        return true;
    }
}

