/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services.profiler.inspectors;

import io.github.thebusybiscuit.slimefun4.core.services.profiler.PerformanceInspector;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerPerformanceInspector
implements PerformanceInspector {
    private final UUID uuid;

    public PlayerPerformanceInspector(@Nonnull Player player) {
        Validate.notNull((Object)player, (String)"Player cannot be null");
        this.uuid = player.getUniqueId();
    }

    @Nullable
    private Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    @Override
    public boolean isValid() {
        Player player = this.getPlayer();
        return player != null && player.isOnline();
    }

    @Override
    public boolean isVerbose() {
        return false;
    }

    @Override
    public void sendMessage(@Nonnull String msg) {
        Player player = this.getPlayer();
        if (player != null) {
            player.sendMessage(msg);
        }
    }

    public void sendMessage(@Nonnull TextComponent component) {
        Player player = this.getPlayer();
        if (player != null) {
            player.spigot().sendMessage((BaseComponent)component);
        }
    }
}

