/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Objects.Category;
import org.apache.commons.lang.Validate;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public interface SlimefunAddon {
    @Nonnull
    public JavaPlugin getJavaPlugin();

    @Nullable
    public String getBugTrackerURL();

    @Nonnull
    default public String getName() {
        return this.getJavaPlugin().getName();
    }

    @Nonnull
    default public String getPluginVersion() {
        return this.getJavaPlugin().getDescription().getVersion();
    }

    @Nonnull
    default public Logger getLogger() {
        return this.getJavaPlugin().getLogger();
    }

    default public boolean hasDependency(@Nonnull String dependency) {
        Validate.notNull((Object)dependency, (String)"The dependency cannot be null");
        if (this.getJavaPlugin().getName().equalsIgnoreCase(dependency)) {
            return true;
        }
        PluginDescriptionFile description = this.getJavaPlugin().getDescription();
        return description.getDepend().contains(dependency) || description.getSoftDepend().contains(dependency);
    }

    @Nonnull
    default public Collection<Category> getCategories() {
        String namespace = this.getJavaPlugin().getName().toLowerCase(Locale.ROOT);
        return SlimefunPlugin.getRegistry().getCategories().stream().filter(cat -> cat.getKey().getNamespace().equals(namespace)).collect(Collectors.toList());
    }
}

