/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.cargo;

import io.github.thebusybiscuit.slimefun4.core.networks.cargo.AbstractItemNetwork;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ItemStackAndInteger;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

final class CargoUtils {
    private static final int[] FILTER_SLOTS = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};

    private CargoUtils() {
    }

    static boolean hasInventory(@Nullable Block block) {
        if (block == null) {
            return false;
        }
        Material type = block.getType();
        if (SlimefunTag.SHULKER_BOXES.isTagged(type)) {
            return true;
        }
        switch (type) {
            case CHEST: 
            case TRAPPED_CHEST: 
            case FURNACE: 
            case DISPENSER: 
            case DROPPER: 
            case HOPPER: 
            case BREWING_STAND: 
            case BARREL: 
            case BLAST_FURNACE: 
            case SMOKER: {
                return true;
            }
        }
        return false;
    }

    static int[] getInputSlotRange(@Nonnull Inventory inv, @Nullable ItemStack item) {
        if (inv instanceof FurnaceInventory) {
            if (item != null && item.getType().isFuel()) {
                if (CargoUtils.isSmeltable(item, true)) {
                    return new int[]{0, 2};
                }
                return new int[]{1, 2};
            }
            return new int[]{0, 1};
        }
        if (inv instanceof BrewerInventory) {
            if (CargoUtils.isPotion(item)) {
                return new int[]{0, 3};
            }
            if (item != null && item.getType() == Material.BLAZE_POWDER) {
                return new int[]{4, 5};
            }
            return new int[]{3, 4};
        }
        return new int[]{0, inv.getSize()};
    }

    static int[] getOutputSlotRange(Inventory inv) {
        if (inv instanceof FurnaceInventory) {
            return new int[]{2, 3};
        }
        if (inv instanceof BrewerInventory) {
            return new int[]{0, 3};
        }
        return new int[]{0, inv.getSize()};
    }

    static ItemStack withdraw(AbstractItemNetwork network, Map<Location, Inventory> inventories, Block node, Block target, ItemStack template) {
        DirtyChestMenu menu = CargoUtils.getChestMenu(target);
        if (menu == null) {
            if (CargoUtils.hasInventory(target)) {
                Inventory inventory = inventories.get(target.getLocation());
                if (inventory != null) {
                    return CargoUtils.withdrawFromVanillaInventory(network, node, template, inventory);
                }
                BlockState state = PaperLib.getBlockState(target, false).getState();
                if (state instanceof InventoryHolder) {
                    inventory = ((InventoryHolder)state).getInventory();
                    inventories.put(target.getLocation(), inventory);
                    return CargoUtils.withdrawFromVanillaInventory(network, node, template, inventory);
                }
            }
            return null;
        }
        ItemStackWrapper wrapper = new ItemStackWrapper(template);
        for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
            ItemStack is = menu.getItemInSlot(slot);
            if (!SlimefunUtils.isItemSimilar(is, wrapper, true) || !CargoUtils.matchesFilter(network, node, is)) continue;
            if (is.getAmount() > template.getAmount()) {
                is.setAmount(is.getAmount() - template.getAmount());
                menu.replaceExistingItem(slot, is.clone());
                return template;
            }
            menu.replaceExistingItem(slot, null);
            return is;
        }
        return null;
    }

    static ItemStack withdrawFromVanillaInventory(AbstractItemNetwork network, Block node, ItemStack template, Inventory inv) {
        ItemStack[] contents = inv.getContents();
        int[] range = CargoUtils.getOutputSlotRange(inv);
        int minSlot = range[0];
        int maxSlot = range[1];
        ItemStackWrapper wrapper = new ItemStackWrapper(template);
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            ItemStack itemInSlot = contents[slot];
            if (!SlimefunUtils.isItemSimilar(itemInSlot, wrapper, true, false) || !CargoUtils.matchesFilter(network, node, itemInSlot)) continue;
            if (itemInSlot.getAmount() > template.getAmount()) {
                itemInSlot.setAmount(itemInSlot.getAmount() - template.getAmount());
                return template;
            }
            ItemStack clone = itemInSlot.clone();
            itemInSlot.setAmount(0);
            return clone;
        }
        return null;
    }

    static ItemStackAndInteger withdraw(AbstractItemNetwork network, Map<Location, Inventory> inventories, Block node, Block target) {
        DirtyChestMenu menu = CargoUtils.getChestMenu(target);
        if (menu != null) {
            for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
                ItemStack is = menu.getItemInSlot(slot);
                if (!CargoUtils.matchesFilter(network, node, is)) continue;
                menu.replaceExistingItem(slot, null);
                return new ItemStackAndInteger(is, slot);
            }
        } else if (CargoUtils.hasInventory(target)) {
            Inventory inventory = inventories.get(target.getLocation());
            if (inventory != null) {
                return CargoUtils.withdrawFromVanillaInventory(network, node, inventory);
            }
            BlockState state = PaperLib.getBlockState(target, false).getState();
            if (state instanceof InventoryHolder) {
                inventory = ((InventoryHolder)state).getInventory();
                inventories.put(target.getLocation(), inventory);
                return CargoUtils.withdrawFromVanillaInventory(network, node, inventory);
            }
        }
        return null;
    }

    private static ItemStackAndInteger withdrawFromVanillaInventory(AbstractItemNetwork network, Block node, Inventory inv) {
        ItemStack[] contents = inv.getContents();
        int[] range = CargoUtils.getOutputSlotRange(inv);
        int minSlot = range[0];
        int maxSlot = range[1];
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            ItemStack is = contents[slot];
            if (!CargoUtils.matchesFilter(network, node, is)) continue;
            inv.setItem(slot, null);
            return new ItemStackAndInteger(is, slot);
        }
        return null;
    }

    static ItemStack insert(AbstractItemNetwork network, Map<Location, Inventory> inventories, Block node, Block target, ItemStack stack) {
        if (!CargoUtils.matchesFilter(network, node, stack)) {
            return stack;
        }
        DirtyChestMenu menu = CargoUtils.getChestMenu(target);
        if (menu == null) {
            if (CargoUtils.hasInventory(target)) {
                Inventory inventory = inventories.get(target.getLocation());
                if (inventory != null) {
                    return CargoUtils.insertIntoVanillaInventory(stack, inventory);
                }
                BlockState state = PaperLib.getBlockState(target, false).getState();
                if (state instanceof InventoryHolder) {
                    inventory = ((InventoryHolder)state).getInventory();
                    inventories.put(target.getLocation(), inventory);
                    return CargoUtils.insertIntoVanillaInventory(stack, inventory);
                }
            }
            return stack;
        }
        ItemStackWrapper wrapper = new ItemStackWrapper(stack);
        for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.INSERT, wrapper)) {
            ItemStack itemInSlot = menu.getItemInSlot(slot);
            if (itemInSlot == null) {
                menu.replaceExistingItem(slot, stack);
                return null;
            }
            int maxStackSize = itemInSlot.getType().getMaxStackSize();
            int currentAmount = itemInSlot.getAmount();
            if (!SlimefunUtils.isItemSimilar(itemInSlot, wrapper, true, false) || currentAmount >= maxStackSize) continue;
            int amount = currentAmount + stack.getAmount();
            itemInSlot.setAmount(Math.min(amount, maxStackSize));
            if (amount > maxStackSize) {
                stack.setAmount(amount - maxStackSize);
            } else {
                stack = null;
            }
            menu.replaceExistingItem(slot, itemInSlot);
            return stack;
        }
        return stack;
    }

    private static ItemStack insertIntoVanillaInventory(ItemStack stack, Inventory inv) {
        ItemStack[] contents = inv.getContents();
        int[] range = CargoUtils.getInputSlotRange(inv, stack);
        int minSlot = range[0];
        int maxSlot = range[1];
        ItemStackWrapper wrapper = new ItemStackWrapper(stack);
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            ItemStack itemInSlot = contents[slot];
            if (itemInSlot == null) {
                inv.setItem(slot, stack);
                return null;
            }
            int maxStackSize = itemInSlot.getType().getMaxStackSize();
            if (!SlimefunUtils.isItemSimilar(itemInSlot, wrapper, true, false) || itemInSlot.getAmount() >= maxStackSize) continue;
            int amount = itemInSlot.getAmount() + stack.getAmount();
            if (amount > maxStackSize) {
                stack.setAmount(amount - maxStackSize);
            } else {
                stack = null;
            }
            itemInSlot.setAmount(Math.min(amount, maxStackSize));
            return stack;
        }
        return stack;
    }

    static DirtyChestMenu getChestMenu(@Nonnull Block block) {
        if (BlockStorage.hasInventory(block)) {
            return BlockStorage.getInventory(block);
        }
        return BlockStorage.getUniversalInventory(block);
    }

    static boolean matchesFilter(@Nonnull AbstractItemNetwork network, @Nonnull Block node, @Nullable ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        return network.getItemFilter(node).test(item);
    }

    private static boolean isSmeltable(@Nullable ItemStack stack, boolean lazy) {
        if (lazy) {
            return stack != null && Tag.LOGS.isTagged((Keyed)stack.getType());
        }
        return SlimefunPlugin.getMinecraftRecipeService().isSmeltable(stack);
    }

    private static boolean isPotion(@Nullable ItemStack item) {
        return item != null && (item.getType() == Material.POTION || item.getType() == Material.SPLASH_POTION || item.getType() == Material.LINGERING_POTION);
    }

    @Deprecated
    public static int[] getWhitelistBlacklistSlots() {
        return FILTER_SLOTS;
    }

    public static int[] getFilteringSlots() {
        return FILTER_SLOTS;
    }
}

