/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.integrations;

import com.gmail.nossr50.events.fake.FakeBlockBreakEvent;
import dev.lone.itemsadder.api.ItemsAdder;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.integrations.ClearLagIntegration;
import io.github.thebusybiscuit.slimefun4.integrations.McMMOIntegration;
import io.github.thebusybiscuit.slimefun4.integrations.PlaceholderAPIIntegration;
import io.github.thebusybiscuit.slimefun4.integrations.WorldEditIntegration;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class IntegrationsManager {
    protected final SlimefunPlugin plugin;
    private boolean isEnabled = false;
    private boolean isPlaceholderAPIInstalled = false;
    private boolean isWorldEditInstalled = false;
    private boolean isMcMMOInstalled = false;
    private boolean isClearLagInstalled = false;
    private boolean isItemsAdderInstalled = false;
    private boolean isChestTerminalInstalled = false;
    private boolean isExoticGardenInstalled = false;

    public IntegrationsManager(@Nonnull SlimefunPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public final void start() {
        if (this.isEnabled) {
            throw new UnsupportedOperationException("All integrations have already been loaded.");
        }
        this.isEnabled = true;
        this.onServerLoad();
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, this::onServerStart);
    }

    private void onServerLoad() {
        this.load("PlaceholderAPI", integration -> {
            new PlaceholderAPIIntegration(this.plugin).register();
            this.isPlaceholderAPIInstalled = true;
        });
        this.load("WorldEdit", integration -> {
            new WorldEditIntegration().register();
            this.isWorldEditInstalled = true;
        });
        this.load("mcMMO", integration -> {
            new McMMOIntegration(this.plugin).register();
            this.isMcMMOInstalled = true;
        });
        this.load("ClearLag", integration -> {
            new ClearLagIntegration(this.plugin).register();
            this.isClearLagInstalled = true;
        });
        this.load("ItemsAdder", integration -> {
            this.isItemsAdderInstalled = true;
        });
    }

    private void onServerStart() {
        this.isChestTerminalInstalled = this.isAddonInstalled("ChestTerminal");
        this.isExoticGardenInstalled = this.isAddonInstalled("ExoticGarden");
    }

    private boolean isAddonInstalled(@Nonnull String addon) {
        if (this.plugin.getServer().getPluginManager().isPluginEnabled(addon)) {
            Slimefun.getLogger().log(Level.INFO, "Hooked into Slimefun Addon: {0}", addon);
            return true;
        }
        return false;
    }

    private void load(@Nonnull String pluginName, @Nonnull Consumer<Plugin> consumer) {
        Plugin integration = this.plugin.getServer().getPluginManager().getPlugin(pluginName);
        if (integration != null && integration.isEnabled()) {
            String version = integration.getDescription().getVersion();
            Slimefun.getLogger().log(Level.INFO, "Hooked into Plugin: {0} v{1}", new Object[]{pluginName, version});
            try {
                consumer.accept(integration);
            }
            catch (Exception | LinkageError x) {
                Slimefun.getLogger().log(Level.WARNING, "Maybe consider updating {0} or Slimefun?", pluginName);
                Slimefun.getLogger().log(Level.WARNING, x, () -> "Failed to hook into " + pluginName + " v" + version);
            }
        }
    }

    public boolean isEventFaked(@Nonnull Event event) {
        return this.isMcMMOInstalled && event instanceof FakeBlockBreakEvent;
    }

    public boolean isCustomBlock(@Nonnull Block block) {
        return this.isItemsAdderInstalled && ItemsAdder.isCustomBlock((Block)block);
    }

    public boolean isPlaceholderAPIInstalled() {
        return this.isPlaceholderAPIInstalled;
    }

    public boolean isWorldEditInstalled() {
        return this.isWorldEditInstalled;
    }

    public boolean isMcMMOInstalled() {
        return this.isMcMMOInstalled;
    }

    public boolean isClearLagInstalled() {
        return this.isClearLagInstalled;
    }

    public boolean isItemsAdderInstalled() {
        return this.isItemsAdderInstalled;
    }

    public boolean isChestTerminalInstalled() {
        return this.isChestTerminalInstalled;
    }

    public boolean isExoticGardenInstalled() {
        return this.isExoticGardenInstalled;
    }
}

