/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.networks.cargo;

import io.github.thebusybiscuit.slimefun4.api.network.Network;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.CargoUtils;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ItemFilter;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ItemRequest;
import io.github.thebusybiscuit.slimefun4.core.networks.cargo.ItemStackAndInteger;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.ChestMenuUtils;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.inventory.UniversalBlockMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.math.DoubleHandler;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Directional;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

abstract class AbstractItemNetwork
extends Network {
    private static final int[] slots = new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    private static final int[] TERMINAL_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 18, 19, 20, 21, 22, 23, 24, 27, 28, 29, 30, 31, 32, 33, 36, 37, 38, 39, 40, 41, 42};
    private static final int TERMINAL_OUT_SLOT = 17;
    private final ItemStack terminalPlaceholderItem = new CustomItem(Material.BARRIER, "&4No Item cached", new String[0]);
    protected final Set<Location> terminals = new HashSet<Location>();
    protected final Set<Location> imports = new HashSet<Location>();
    protected final Set<Location> exports = new HashSet<Location>();
    private final Queue<ItemRequest> itemRequests = new LinkedList<ItemRequest>();
    protected Map<Location, BlockFace> connectorCache = new HashMap<Location, BlockFace>();
    protected Map<Location, ItemFilter> filterCache = new HashMap<Location, ItemFilter>();

    protected AbstractItemNetwork(Location regulator) {
        super(SlimefunPlugin.getNetworkManager(), regulator);
    }

    protected Optional<Block> getAttachedBlock(Location l) {
        Block block;
        if (l.getWorld().isChunkLoaded(l.getBlockX() >> 4, l.getBlockZ() >> 4) && (block = l.getBlock()).getType() == Material.PLAYER_WALL_HEAD) {
            BlockFace cached = this.connectorCache.get(l);
            if (cached != null) {
                return Optional.of(block.getRelative(cached));
            }
            BlockFace face = ((Directional)block.getBlockData()).getFacing().getOppositeFace();
            this.connectorCache.put(l, face);
            return Optional.of(block.getRelative(face));
        }
        return Optional.empty();
    }

    protected void handleItemRequests(Map<Location, Inventory> inventories, Set<Location> providers, Set<Location> destinations) {
        this.collectImportRequests(inventories);
        this.collectExportRequests(inventories);
        this.collectTerminalRequests();
        Iterator<ItemRequest> iterator = this.itemRequests.iterator();
        while (iterator.hasNext()) {
            ItemRequest request = (ItemRequest)iterator.next();
            BlockMenu menu = BlockStorage.getInventory(request.getTerminal());
            if (menu == null) continue;
            switch (request.getDirection()) {
                case INSERT: {
                    this.distributeInsertionRequest(inventories, request, menu, iterator, destinations);
                    break;
                }
                case WITHDRAW: {
                    this.collectExtractionRequest(inventories, request, menu, iterator, providers);
                    break;
                }
            }
        }
    }

    private void distributeInsertionRequest(Map<Location, Inventory> inventories, ItemRequest request, BlockMenu terminal, Iterator<ItemRequest> iterator, Set<Location> destinations) {
        ItemStack item = request.getItem();
        for (Location l : destinations) {
            Optional<Block> target = this.getAttachedBlock(l);
            if (!target.isPresent() || (item = CargoUtils.insert(this, inventories, l.getBlock(), target.get(), item)) != null) continue;
            terminal.replaceExistingItem(request.getSlot(), null);
            break;
        }
        if (item != null) {
            terminal.replaceExistingItem(request.getSlot(), item);
        }
        iterator.remove();
    }

    private void collectExtractionRequest(Map<Location, Inventory> inventories, ItemRequest request, BlockMenu terminal, Iterator<ItemRequest> iterator, Set<Location> providers) {
        int slot = request.getSlot();
        ItemStack prevStack = terminal.getItemInSlot(slot);
        if (!(prevStack == null || prevStack.getAmount() + request.getItem().getAmount() <= prevStack.getMaxStackSize() && SlimefunUtils.isItemSimilar(prevStack, request.getItem(), true, false))) {
            iterator.remove();
            return;
        }
        Object stack = null;
        ItemStack item = request.getItem();
        for (Location l : providers) {
            ItemStack is;
            Optional<Block> target = this.getAttachedBlock(l);
            if (!target.isPresent() || (is = CargoUtils.withdraw(this, inventories, l.getBlock(), target.get(), item)) == null) continue;
            stack = stack == null ? is : new CustomItem((ItemStack)stack, stack.getAmount() + is.getAmount());
            if (is.getAmount() == item.getAmount()) break;
            item = new CustomItem(item, item.getAmount() - is.getAmount());
        }
        if (stack != null) {
            ItemStack prev = terminal.getItemInSlot(slot);
            if (prev == null) {
                terminal.replaceExistingItem(slot, (ItemStack)stack);
            } else {
                terminal.replaceExistingItem(slot, new CustomItem((ItemStack)stack, stack.getAmount() + prev.getAmount()));
            }
        }
        iterator.remove();
    }

    private void collectImportRequests(Map<Location, Inventory> inventories) {
        SlimefunItem item = SlimefunItem.getByID("CT_IMPORT_BUS");
        for (Location bus : this.imports) {
            ItemStackAndInteger stack;
            Optional<Block> target;
            long timestamp = SlimefunPlugin.getProfiler().newEntry();
            BlockMenu menu = BlockStorage.getInventory(bus);
            if (menu.getItemInSlot(17) == null && (target = this.getAttachedBlock(bus)).isPresent() && (stack = CargoUtils.withdraw(this, inventories, bus.getBlock(), target.get())) != null) {
                menu.replaceExistingItem(17, stack.getItem());
            }
            if (menu.getItemInSlot(17) != null) {
                this.itemRequests.add(new ItemRequest(bus, 17, menu.getItemInSlot(17), ItemTransportFlow.INSERT));
            }
            SlimefunPlugin.getProfiler().closeEntry(bus, item, timestamp);
        }
    }

    private void collectExportRequests(Map<Location, Inventory> inventories) {
        SlimefunItem item = SlimefunItem.getByID("CT_EXPORT_BUS");
        for (Location bus : this.exports) {
            long timestamp = SlimefunPlugin.getProfiler().newEntry();
            BlockMenu menu = BlockStorage.getInventory(bus);
            if (menu.getItemInSlot(17) != null) {
                Optional<Block> target = this.getAttachedBlock(bus);
                target.ifPresent(block -> menu.replaceExistingItem(17, CargoUtils.insert(this, inventories, bus.getBlock(), block, menu.getItemInSlot(17))));
            }
            if (menu.getItemInSlot(17) == null) {
                ArrayList<CustomItem> items = new ArrayList<CustomItem>();
                for (int slot : slots) {
                    ItemStack template = menu.getItemInSlot(slot);
                    if (template == null) continue;
                    items.add(new CustomItem(template, 1));
                }
                if (!items.isEmpty()) {
                    int index = Integer.parseInt(BlockStorage.getLocationInfo(bus, "index"));
                    if (++index > items.size() - 1) {
                        index = 0;
                    }
                    BlockStorage.addBlockInfo(bus, "index", String.valueOf(index));
                    this.itemRequests.add(new ItemRequest(bus, 17, (ItemStack)items.get(index), ItemTransportFlow.WITHDRAW));
                }
            }
            SlimefunPlugin.getProfiler().closeEntry(bus, item, timestamp);
        }
    }

    private void collectTerminalRequests() {
        for (Location terminal : this.terminals) {
            BlockMenu menu = BlockStorage.getInventory(terminal);
            ItemStack sendingItem = menu.getItemInSlot(17);
            if (sendingItem == null) continue;
            this.itemRequests.add(new ItemRequest(terminal, 17, sendingItem, ItemTransportFlow.INSERT));
        }
    }

    protected long updateTerminals(@Nonnull Set<Location> providers) {
        if (this.terminals.isEmpty()) {
            return 0L;
        }
        long timestamp = System.nanoTime();
        Location firstTerminal = null;
        SlimefunItem item = SlimefunItem.getByID("CHEST_TERMINAL");
        List<ItemStackAndInteger> items = this.findAvailableItems(providers);
        try {
            for (Location l : this.terminals) {
                int page;
                BlockMenu terminal = BlockStorage.getInventory(l);
                String data = BlockStorage.getLocationInfo(l, "page");
                int n = page = data == null ? 1 : Integer.parseInt(data);
                if (!items.isEmpty() && items.size() < (page - 1) * TERMINAL_SLOTS.length + 1) {
                    page = 1;
                    BlockStorage.addBlockInfo(l, "page", String.valueOf(1));
                }
                for (int i = 0; i < TERMINAL_SLOTS.length; ++i) {
                    int slot = TERMINAL_SLOTS[i];
                    int index = i + TERMINAL_SLOTS.length * (page - 1);
                    this.updateTerminal(l, terminal, slot, index, items);
                }
                if (firstTerminal != null) continue;
                firstTerminal = l;
            }
        }
        catch (Exception | LinkageError x) {
            item.error("An Exception was caused while trying to tick Chest terminals", x);
        }
        if (firstTerminal != null) {
            return SlimefunPlugin.getProfiler().closeEntry(firstTerminal, item, timestamp);
        }
        return System.nanoTime() - timestamp;
    }

    @Override
    public void markDirty(@Nonnull Location l) {
        this.markCargoNodeConfigurationDirty(l);
        super.markDirty(l);
    }

    public void markCargoNodeConfigurationDirty(@Nonnull Location node) {
        ItemFilter filter = this.filterCache.get(node);
        if (filter != null) {
            filter.markDirty();
        }
        this.connectorCache.remove(node);
    }

    @ParametersAreNonnullByDefault
    private void updateTerminal(Location l, BlockMenu terminal, int slot, int index, List<ItemStackAndInteger> items) {
        if (items.size() > index) {
            ItemStackAndInteger item = items.get(index);
            ItemStack stack = item.getItem().clone();
            stack.setAmount(1);
            ItemMeta im = stack.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("");
            lore.add(ChatColors.color("&7Stored Items: &f" + DoubleHandler.getFancyDouble(item.getInt())));
            if (stack.getMaxStackSize() > 1) {
                int amount = item.getInt() > stack.getMaxStackSize() ? stack.getMaxStackSize() : item.getInt();
                lore.add(ChatColors.color("&7<Left Click: Request 1 | Right Click: Request " + amount + ">"));
            } else {
                lore.add(ChatColors.color("&7<Left Click: Request 1>"));
            }
            lore.add("");
            if (im.hasLore()) {
                lore.addAll(im.getLore());
            }
            im.setLore(lore);
            stack.setItemMeta(im);
            terminal.replaceExistingItem(slot, stack);
            terminal.addMenuClickHandler(slot, (p, sl, is, action) -> {
                int amount = item.getInt() > item.getItem().getMaxStackSize() ? item.getItem().getMaxStackSize() : item.getInt();
                CustomItem requestedItem = new CustomItem(item.getItem(), action.isRightClicked() ? amount : 1);
                this.itemRequests.add(new ItemRequest(l, 44, requestedItem, ItemTransportFlow.WITHDRAW));
                return false;
            });
        } else {
            terminal.replaceExistingItem(slot, this.terminalPlaceholderItem);
            terminal.addMenuClickHandler(slot, ChestMenuUtils.getEmptyClickHandler());
        }
    }

    @Nonnull
    private List<ItemStackAndInteger> findAvailableItems(@Nonnull Set<Location> providers) {
        LinkedList<ItemStackAndInteger> items = new LinkedList<ItemStackAndInteger>();
        for (Location l : providers) {
            Optional<Block> block = this.getAttachedBlock(l);
            if (!block.isPresent()) continue;
            this.findAllItems(items, l, block.get());
        }
        Collections.sort(items, Comparator.comparingInt(item -> -item.getInt()));
        return items;
    }

    @ParametersAreNonnullByDefault
    private void findAllItems(List<ItemStackAndInteger> items, Location l, Block target) {
        block5: {
            BlockState state;
            block6: {
                block4: {
                    UniversalBlockMenu menu = BlockStorage.getUniversalInventory(target);
                    if (menu == null) break block4;
                    for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
                        ItemStack is = menu.getItemInSlot(slot);
                        this.filter(is, items, l);
                    }
                    break block5;
                }
                if (!BlockStorage.hasInventory(target)) break block6;
                BlockMenu blockMenu = BlockStorage.getInventory(target);
                if (blockMenu.getPreset().getID().startsWith("BARREL_")) {
                    this.gatherItemsFromBarrel(l, blockMenu, items);
                } else {
                    this.handleWithdraw(blockMenu, items, l);
                }
                break block5;
            }
            if (!CargoUtils.hasInventory(target) || !((state = PaperLib.getBlockState(target, false).getState()) instanceof InventoryHolder)) break block5;
            Inventory inv = ((InventoryHolder)state).getInventory();
            for (ItemStack is : inv.getContents()) {
                this.filter(is, items, l);
            }
        }
    }

    @ParametersAreNonnullByDefault
    private void gatherItemsFromBarrel(Location l, BlockMenu blockMenu, List<ItemStackAndInteger> items) {
        try {
            Config cfg = BlockStorage.getLocationInfo(blockMenu.getLocation());
            String data = cfg.getString("storedItems");
            if (data == null) {
                return;
            }
            int stored = Integer.parseInt(data);
            for (int slot : blockMenu.getPreset().getSlotsAccessedByItemTransport(blockMenu, ItemTransportFlow.WITHDRAW, null)) {
                ItemStack stack = blockMenu.getItemInSlot(slot);
                if (stack == null || !CargoUtils.matchesFilter(this, l.getBlock(), stack)) continue;
                boolean add = true;
                for (ItemStackAndInteger item : items) {
                    if (!SlimefunUtils.isItemSimilar(stack, item.getItemStackWrapper(), true, false)) continue;
                    add = false;
                    item.add(stack.getAmount() + stored);
                }
                if (!add) continue;
                items.add(new ItemStackAndInteger(stack, stack.getAmount() + stored));
            }
        }
        catch (Exception x) {
            Slimefun.getLogger().log(Level.SEVERE, "An Exception occurred while trying to read data from a Barrel", x);
        }
    }

    @ParametersAreNonnullByDefault
    private void handleWithdraw(DirtyChestMenu menu, List<ItemStackAndInteger> items, Location l) {
        for (int slot : menu.getPreset().getSlotsAccessedByItemTransport(menu, ItemTransportFlow.WITHDRAW, null)) {
            this.filter(menu.getItemInSlot(slot), items, l);
        }
    }

    @ParametersAreNonnullByDefault
    private void filter(@Nullable ItemStack stack, List<ItemStackAndInteger> items, Location node) {
        if (stack != null && CargoUtils.matchesFilter(this, node.getBlock(), stack)) {
            boolean add = true;
            for (ItemStackAndInteger item : items) {
                if (!SlimefunUtils.isItemSimilar(stack, item.getItemStackWrapper(), true, false)) continue;
                add = false;
                item.add(stack.getAmount());
            }
            if (add) {
                items.add(new ItemStackAndInteger(stack, stack.getAmount()));
            }
        }
    }

    @Nonnull
    protected ItemFilter getItemFilter(@Nonnull Block node) {
        Location loc = node.getLocation();
        ItemFilter filter = this.filterCache.get(loc);
        if (filter == null) {
            ItemFilter newFilter = new ItemFilter(node);
            this.filterCache.put(loc, newFilter);
            return newFilter;
        }
        if (filter.isDirty()) {
            filter.update(node);
            return filter;
        }
        return filter;
    }
}

