/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.api.events.AutoDisenchantEvent;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.InvUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;

public class AutoDisenchanter
extends AContainer {
    public AutoDisenchanter(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.DIAMOND_CHESTPLATE);
    }

    @Override
    protected MachineRecipe findNextRecipe(BlockMenu menu) {
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
        for (int slot : this.getInputSlots()) {
            ItemStack item = menu.getItemInSlot(slot);
            if (!this.isDisenchantable(item)) {
                return null;
            }
            AutoDisenchantEvent event = new AutoDisenchantEvent(item);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return null;
            }
            ItemStack target = menu.getItemInSlot(slot == this.getInputSlots()[0] ? this.getInputSlots()[1] : this.getInputSlots()[0]);
            if (target == null || target.getType() != Material.BOOK) continue;
            int amount = 0;
            for (Map.Entry entry : item.getEnchantments().entrySet()) {
                enchantments.put((Enchantment)entry.getKey(), (Integer)entry.getValue());
                ++amount;
            }
            if (amount <= 0) continue;
            ItemStack disenchantedItem = item.clone();
            disenchantedItem.setAmount(1);
            ItemStack book = new ItemStack(Material.ENCHANTED_BOOK);
            this.transferEnchantments(disenchantedItem, book, enchantments);
            MachineRecipe recipe = new MachineRecipe(90 * amount / this.getSpeed(), new ItemStack[]{target, item}, new ItemStack[]{disenchantedItem, book});
            if (!InvUtils.fitAll(menu.toInventory(), recipe.getOutput(), this.getOutputSlots())) {
                return null;
            }
            for (int inputSlot : this.getInputSlots()) {
                menu.consumeItem(inputSlot);
            }
            return recipe;
        }
        return null;
    }

    private void transferEnchantments(ItemStack item, ItemStack book, Map<Enchantment, Integer> enchantments) {
        ItemMeta itemMeta = item.getItemMeta();
        ItemMeta bookMeta = book.getItemMeta();
        ((Repairable)bookMeta).setRepairCost(((Repairable)itemMeta).getRepairCost());
        ((Repairable)itemMeta).setRepairCost(0);
        item.setItemMeta(itemMeta);
        book.setItemMeta(bookMeta);
        EnchantmentStorageMeta meta = (EnchantmentStorageMeta)book.getItemMeta();
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            item.removeEnchantment(entry.getKey());
            meta.addStoredEnchant(entry.getKey(), entry.getValue().intValue(), true);
        }
        book.setItemMeta((ItemMeta)meta);
    }

    private boolean isDisenchantable(@Nullable ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.getType() != Material.BOOK) {
            SlimefunItem sfItem = SlimefunItem.getByItem(item);
            return sfItem == null || sfItem.isDisenchantable();
        }
        return true;
    }

    @Override
    public String getMachineIdentifier() {
        return "AUTO_DISENCHANTER";
    }
}

