/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.network;

import io.github.thebusybiscuit.slimefun4.api.network.NetworkComponent;
import io.github.thebusybiscuit.slimefun4.api.network.NetworkVisualizer;
import io.github.thebusybiscuit.slimefun4.core.networks.NetworkManager;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;

public abstract class Network {
    private final NetworkManager manager;
    protected Location regulator;
    private final Queue<Location> nodeQueue = new ArrayDeque<Location>();
    protected final Set<Location> connectedLocations = new HashSet<Location>();
    protected final Set<Location> regulatorNodes = new HashSet<Location>();
    protected final Set<Location> connectorNodes = new HashSet<Location>();
    protected final Set<Location> terminusNodes = new HashSet<Location>();

    protected Network(@Nonnull NetworkManager manager, @Nonnull Location regulator) {
        Validate.notNull((Object)manager, (String)"A NetworkManager must be provided");
        Validate.notNull((Object)regulator, (String)"No regulator was specified");
        this.manager = manager;
        this.regulator = regulator;
        this.connectedLocations.add(regulator);
        this.nodeQueue.add(regulator.clone());
    }

    public abstract int getRange();

    @Nullable
    public abstract NetworkComponent classifyLocation(@Nonnull Location var1);

    public abstract void onClassificationChange(Location var1, NetworkComponent var2, NetworkComponent var3);

    public int getSize() {
        return this.regulatorNodes.size() + this.connectorNodes.size() + this.terminusNodes.size();
    }

    protected void addLocationToNetwork(@Nonnull Location l) {
        if (this.connectedLocations.add(l.clone())) {
            this.markDirty(l);
        }
    }

    public void markDirty(@Nonnull Location l) {
        if (this.regulator.equals((Object)l)) {
            this.manager.unregisterNetwork(this);
        } else {
            this.nodeQueue.add(l.clone());
        }
    }

    public boolean connectsTo(@Nonnull Location l) {
        return this.connectedLocations.contains(l);
    }

    @Nullable
    private NetworkComponent getCurrentClassification(@Nonnull Location l) {
        if (this.regulatorNodes.contains(l)) {
            return NetworkComponent.REGULATOR;
        }
        if (this.connectorNodes.contains(l)) {
            return NetworkComponent.CONNECTOR;
        }
        if (this.terminusNodes.contains(l)) {
            return NetworkComponent.TERMINUS;
        }
        return null;
    }

    private void discoverStep() {
        int maxSteps = this.manager.getMaxSize();
        int steps = 0;
        while (this.nodeQueue.peek() != null) {
            Location l = this.nodeQueue.poll();
            NetworkComponent currentAssignment = this.getCurrentClassification(l);
            NetworkComponent classification = this.classifyLocation(l);
            if (classification != currentAssignment) {
                if (currentAssignment == NetworkComponent.REGULATOR || currentAssignment == NetworkComponent.CONNECTOR) {
                    this.manager.unregisterNetwork(this);
                    return;
                }
                if (currentAssignment == NetworkComponent.TERMINUS) {
                    this.terminusNodes.remove(l);
                }
                if (classification == NetworkComponent.REGULATOR) {
                    this.regulatorNodes.add(l);
                    this.discoverNeighbors(l);
                } else if (classification == NetworkComponent.CONNECTOR) {
                    this.connectorNodes.add(l);
                    this.discoverNeighbors(l);
                } else if (classification == NetworkComponent.TERMINUS) {
                    this.terminusNodes.add(l);
                }
                this.onClassificationChange(l, currentAssignment, classification);
            }
            if (++steps < maxSteps) continue;
            break;
        }
    }

    private void discoverNeighbors(@Nonnull Location l, double xDiff, double yDiff, double zDiff) {
        for (int i = this.getRange() + 1; i > 0; --i) {
            Location newLocation = l.clone().add((double)i * xDiff, (double)i * yDiff, (double)i * zDiff);
            this.addLocationToNetwork(newLocation);
        }
    }

    private void discoverNeighbors(@Nonnull Location l) {
        this.discoverNeighbors(l, 1.0, 0.0, 0.0);
        this.discoverNeighbors(l, -1.0, 0.0, 0.0);
        this.discoverNeighbors(l, 0.0, 1.0, 0.0);
        this.discoverNeighbors(l, 0.0, -1.0, 0.0);
        this.discoverNeighbors(l, 0.0, 0.0, 1.0);
        this.discoverNeighbors(l, 0.0, 0.0, -1.0);
    }

    public void display() {
        if (this.manager.isVisualizerEnabled()) {
            SlimefunPlugin.runSync(new NetworkVisualizer(this));
        }
    }

    @Nonnull
    public Location getRegulator() {
        return this.regulator;
    }

    public void tick() {
        this.discoverStep();
    }
}

