/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.blocks;

import java.lang.ref.WeakReference;
import lombok.NonNull;
import org.bukkit.Chunk;
import org.bukkit.World;

public final class ChunkPosition {
    private final WeakReference<World> world;
    private final long position;

    public ChunkPosition(@NonNull World world, long position) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        this.world = new WeakReference<World>(world);
        this.position = position;
    }

    public ChunkPosition(@NonNull World world, int x, int z) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        this.world = new WeakReference<World>(world);
        this.position = (long)(x & 0x3FFFFFF) << 38 | (long)(z & 0xFFF);
    }

    public ChunkPosition(@NonNull Chunk chunk) {
        this(chunk.getWorld(), chunk.getX(), chunk.getZ());
        if (chunk == null) {
            throw new NullPointerException("chunk is marked non-null but is null");
        }
    }

    public World getWorld() {
        World ref = (World)this.world.get();
        if (ref == null) {
            throw new IllegalStateException("The reference of this BlockPositions world has been cleared");
        }
        return ref;
    }

    public long getPosition() {
        return this.position;
    }

    public int getX() {
        return (int)(this.position >> 38);
    }

    public int getZ() {
        return (int)(this.position & 0xFFFL);
    }

    public Chunk getChunk() {
        World ref = (World)this.world.get();
        if (ref == null) {
            throw new IllegalStateException("Cannot get Chunk when the world isn't loaded");
        }
        return ref.getChunkAt(this.getX(), this.getZ());
    }

    public boolean equals(Object o) {
        if (o instanceof ChunkPosition) {
            ChunkPosition pos = (ChunkPosition)o;
            if (pos.world.get() == null) {
                return false;
            }
            return this.getWorld().getUID().equals(pos.getWorld().getUID()) && this.position == pos.position;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        World ref = (World)this.world.get();
        int result = 0;
        result += 31 * (ref == null ? 0 : ref.hashCode());
        return result += 31 * Long.hashCode(this.position);
    }

    public String toString() {
        World w = (World)this.world.get();
        String worldName = w != null ? w.getName() : "<no reference>";
        return String.format("ChunkPosition(world=%s, x=%d, z=%d, position=%d)", worldName, this.getX(), this.getZ(), this.getPosition());
    }
}

