/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.tasks;

import io.github.thebusybiscuit.slimefun4.utils.HeadTexture;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.cscorelib2.skull.SkullBlock;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class CapacitorTextureUpdateTask
implements Runnable {
    private final Location l;
    private final double filledPercentage;

    public CapacitorTextureUpdateTask(@Nonnull Location l, double charge, double capacity) {
        Validate.notNull((Object)l, (String)"The Location cannot be null");
        this.l = l;
        this.filledPercentage = charge / capacity;
    }

    @Override
    public void run() {
        Block b = this.l.getBlock();
        if (b.getType() == Material.PLAYER_HEAD || b.getType() == Material.PLAYER_WALL_HEAD) {
            if (this.filledPercentage <= 0.25) {
                SkullBlock.setFromHash(b, HeadTexture.CAPACITOR_25.getTexture());
            } else if (this.filledPercentage <= 0.5) {
                SkullBlock.setFromHash(b, HeadTexture.CAPACITOR_50.getTexture());
            } else if (this.filledPercentage <= 0.75) {
                SkullBlock.setFromHash(b, HeadTexture.CAPACITOR_75.getTexture());
            } else {
                SkullBlock.setFromHash(b, HeadTexture.CAPACITOR_100.getTexture());
            }
        }
    }
}

