/*
 * Decompiled with CFR 0.152.
 */
package me.mrCookieSlime.Slimefun.cscorelib2.updater;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.logging.Level;
import javax.annotation.Nullable;
import lombok.NonNull;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.UpdateInfo;
import me.mrCookieSlime.Slimefun.cscorelib2.updater.Updater;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

abstract class UpdaterTask
implements Runnable {
    private final Plugin plugin;
    private final File file;
    private final URL url;
    private final int timeout;
    private final String localVersion;

    UpdaterTask(@NonNull Updater updater, @NonNull URL url) {
        if (updater == null) {
            throw new NullPointerException("updater is marked non-null but is null");
        }
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        this.plugin = updater.getPlugin();
        this.file = updater.getFile();
        this.url = url;
        this.timeout = updater.getTimeout();
        this.localVersion = updater.getLocalVersion();
    }

    @Nullable
    public abstract UpdateInfo parse(String var1) throws MalformedURLException;

    public abstract boolean hasUpdate(String var1, String var2);

    @Override
    public void run() {
        try {
            UpdateInfo latestVersion = this.getLatestVersion(this.url);
            if (latestVersion != null) {
                this.validateAndInstall(latestVersion);
            }
        }
        catch (NumberFormatException x) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not auto-update {0}", this.plugin.getName());
            this.plugin.getLogger().log(Level.SEVERE, "Unrecognized Version: {0}", this.localVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private UpdateInfo getLatestVersion(@NonNull URL url) {
        UpdateInfo updateInfo;
        block7: {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(this.timeout);
            connection.addRequestProperty("User-Agent", "Auto Updater (by TheBusyBiscuit)");
            connection.setDoOutput(true);
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            try {
                updateInfo = this.parse(reader.readLine());
                if (Collections.singletonList(reader).get(0) == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (Collections.singletonList(reader).get(0) != null) {
                        reader.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.plugin.getLogger().log(Level.WARNING, "Could not connect to the updating site, is it down?", e);
                    this.join();
                    return null;
                }
            }
            reader.close();
        }
        return updateInfo;
    }

    private void validateAndInstall(@NonNull UpdateInfo latestVersion) {
        if (latestVersion == null) {
            throw new NullPointerException("latestVersion is marked non-null but is null");
        }
        if (this.hasUpdate(this.localVersion, latestVersion.getVersion())) {
            this.install(latestVersion);
        } else {
            this.plugin.getLogger().log(Level.INFO, "{0} is already up to date!", this.plugin.getName());
            this.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void install(@NonNull UpdateInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        this.plugin.getLogger().log(Level.INFO, "{0} is outdated!", this.plugin.getName());
        this.plugin.getLogger().log(Level.INFO, "Downloading {0}, version: {1}", new Object[]{this.plugin.getName(), info.getVersion()});
        try {
            try (BufferedInputStream input = new BufferedInputStream(info.getUrl().openStream());
                 FileOutputStream output = new FileOutputStream(new File("plugins/" + Bukkit.getUpdateFolder(), this.file.getName()));){
                int read;
                byte[] data = new byte[1024];
                while ((read = input.read(data, 0, 1024)) != -1) {
                    output.write(data, 0, read);
                }
            }
            this.plugin.getLogger().log(Level.INFO, " ");
            this.plugin.getLogger().log(Level.INFO, "#################### - UPDATE - ####################");
        }
        catch (Exception x) {
            try {
                this.plugin.getLogger().log(Level.SEVERE, x, () -> "Failed to auto-update " + this.plugin.getName());
                this.plugin.getLogger().log(Level.INFO, " ");
                this.plugin.getLogger().log(Level.INFO, "#################### - UPDATE - ####################");
            }
            catch (Throwable throwable) {
                this.plugin.getLogger().log(Level.INFO, " ");
                this.plugin.getLogger().log(Level.INFO, "#################### - UPDATE - ####################");
                this.plugin.getLogger().log(Level.INFO, "{0} was successfully updated ({1} -> {2})", new Object[]{this.plugin.getName(), this.localVersion, info.getVersion()});
                this.plugin.getLogger().log(Level.INFO, "Please restart your Server in order to use the new Version");
                this.plugin.getLogger().log(Level.INFO, " ");
                this.join();
                throw throwable;
            }
            this.plugin.getLogger().log(Level.INFO, "{0} was successfully updated ({1} -> {2})", new Object[]{this.plugin.getName(), this.localVersion, info.getVersion()});
            this.plugin.getLogger().log(Level.INFO, "Please restart your Server in order to use the new Version");
            this.plugin.getLogger().log(Level.INFO, " ");
            this.join();
        }
        this.plugin.getLogger().log(Level.INFO, "{0} was successfully updated ({1} -> {2})", new Object[]{this.plugin.getName(), this.localVersion, info.getVersion()});
        this.plugin.getLogger().log(Level.INFO, "Please restart your Server in order to use the new Version");
        this.plugin.getLogger().log(Level.INFO, " ");
        this.join();
    }

    private void join() {
        try {
            Thread.currentThread().join();
        }
        catch (InterruptedException x) {
            this.plugin.getLogger().log(Level.SEVERE, "The Auto-Updater Thread was interrupted", x);
            Thread.currentThread().interrupt();
        }
    }
}

