/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.features.blockstatesnapshot.BlockStateSnapshotResult;
import java.util.Optional;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BlockDataService
implements Keyed {
    private final NamespacedKey namespacedKey;

    public BlockDataService(@Nonnull Plugin plugin, @Nonnull String key) {
        this.namespacedKey = new NamespacedKey(plugin, key);
    }

    public NamespacedKey getKey() {
        return this.namespacedKey;
    }

    public void setBlockData(@Nonnull Block b, @Nonnull String value) {
        Validate.notNull((Object)b, (String)"The block cannot be null!");
        Validate.notNull((Object)value, (String)"The value cannot be null!");
        boolean useSnapshot = SlimefunPlugin.getMinecraftVersion().isBefore(MinecraftVersion.MINECRAFT_1_16);
        BlockStateSnapshotResult result = PaperLib.getBlockState(b, useSnapshot);
        BlockState state = result.getState();
        if (state instanceof TileState) {
            try {
                PersistentDataContainer container = ((TileState)state).getPersistentDataContainer();
                container.set(this.namespacedKey, PersistentDataType.STRING, (Object)value);
                if (result.isSnapshot()) {
                    state.update();
                }
            }
            catch (Exception x) {
                Slimefun.getLogger().log(Level.SEVERE, "Please check if your Server Software is up to date!");
                String serverSoftware = PaperLib.isSpigot() && !PaperLib.isPaper() ? "Spigot" : Bukkit.getName();
                Slimefun.getLogger().log(Level.SEVERE, () -> serverSoftware + " | " + Bukkit.getVersion() + " | " + Bukkit.getBukkitVersion());
                Slimefun.getLogger().log(Level.SEVERE, "An Exception was thrown while trying to set Persistent Data for a Block", x);
            }
        }
    }

    public Optional<String> getBlockData(@Nonnull Block b) {
        Validate.notNull((Object)b, (String)"The block cannot be null!");
        BlockState state = PaperLib.getBlockState(b, false).getState();
        if (state instanceof TileState) {
            PersistentDataContainer container = ((TileState)state).getPersistentDataContainer();
            return Optional.ofNullable((String)container.get(this.namespacedKey, PersistentDataType.STRING));
        }
        return Optional.empty();
    }

    public boolean isTileEntity(@Nullable Material type) {
        if (type == null || type.isAir()) {
            return false;
        }
        switch (type) {
            case PLAYER_HEAD: 
            case PLAYER_WALL_HEAD: 
            case CHEST: 
            case DISPENSER: 
            case BREWING_STAND: 
            case DROPPER: 
            case FURNACE: 
            case BLAST_FURNACE: 
            case HOPPER: 
            case LECTERN: 
            case JUKEBOX: 
            case ENDER_CHEST: 
            case ENCHANTING_TABLE: 
            case DAYLIGHT_DETECTOR: 
            case SMOKER: 
            case BARREL: 
            case SPAWNER: 
            case BEACON: {
                return true;
            }
        }
        return false;
    }
}

