/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.BackpackCrafter;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.Slimefun;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.inventory.ItemUtils;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ArmorForge
extends BackpackCrafter {
    public ArmorForge(Category category, SlimefunItemStack item) {
        super(category, item, new ItemStack[]{null, null, null, null, new ItemStack(Material.ANVIL), null, null, new CustomItem(Material.DISPENSER, "Dispenser (Facing up)", new String[0]), null}, BlockFace.SELF);
    }

    @Override
    public void onInteract(Player p, Block b) {
        Block dispenser = b.getRelative(BlockFace.DOWN);
        BlockState state = PaperLib.getBlockState(dispenser, false).getState();
        if (state instanceof Dispenser) {
            Dispenser disp = (Dispenser)state;
            Inventory inv = disp.getInventory();
            List<ItemStack[]> inputs = RecipeType.getRecipeInputList(this);
            for (int i = 0; i < inputs.size(); ++i) {
                if (!this.isCraftable(inv, inputs.get(i))) continue;
                ItemStack output = RecipeType.getRecipeOutputList(this, inputs.get(i)).clone();
                if (Slimefun.hasUnlocked(p, output, true)) {
                    this.craft(p, output, inv, dispenser);
                }
                return;
            }
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.pattern-not-found", true);
        }
    }

    private boolean isCraftable(Inventory inv, ItemStack[] recipe) {
        for (int j = 0; j < inv.getContents().length; ++j) {
            if (SlimefunUtils.isItemSimilar(inv.getContents()[j], recipe[j], true)) continue;
            return false;
        }
        return true;
    }

    @ParametersAreNonnullByDefault
    private void craft(Player p, ItemStack output, Inventory inv, Block dispenser) {
        Inventory fakeInv = this.createVirtualInventory(inv);
        Inventory outputInv = this.findOutputInventory(output, dispenser, inv, fakeInv);
        if (outputInv != null) {
            int j;
            for (j = 0; j < 9; ++j) {
                ItemStack item = inv.getContents()[j];
                if (item == null || item.getType() == Material.AIR) continue;
                ItemUtils.consumeItem(item, true);
            }
            for (j = 0; j < 4; ++j) {
                int current = j;
                SlimefunPlugin.runSync(() -> {
                    if (current < 3) {
                        p.getWorld().playSound(p.getLocation(), Sound.BLOCK_ANVIL_USE, 1.0f, 2.0f);
                    } else {
                        p.getWorld().playSound(p.getLocation(), Sound.ENTITY_ARROW_HIT_PLAYER, 1.0f, 1.0f);
                        outputInv.addItem(new ItemStack[]{output});
                    }
                }, (long)j * 20L);
            }
        } else {
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.full-inventory", true);
        }
    }
}

