/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.AContainer;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineRecipe;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class AutoAnvil
extends AContainer {
    private final int repairFactor;

    public AutoAnvil(Category category, int repairFactor, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.repairFactor = repairFactor;
    }

    @Override
    public ItemStack getProgressBar() {
        return new ItemStack(Material.IRON_PICKAXE);
    }

    @Override
    public int getSpeed() {
        return 1;
    }

    @Override
    public String getMachineIdentifier() {
        return "AUTO_ANVIL";
    }

    @Override
    protected MachineRecipe findNextRecipe(BlockMenu menu) {
        for (int slot : this.getInputSlots()) {
            ItemStack ductTape = menu.getItemInSlot(slot == this.getInputSlots()[0] ? this.getInputSlots()[1] : this.getInputSlots()[0]);
            ItemStack item = menu.getItemInSlot(slot);
            if (item == null || item.getType().getMaxDurability() <= 0 || ((Damageable)item.getItemMeta()).getDamage() <= 0) continue;
            if (!SlimefunUtils.isItemSimilar(ductTape, SlimefunItems.DUCT_TAPE, true, false)) break;
            ItemStack repairedItem = this.repair(item);
            if (!menu.fits(repairedItem, this.getOutputSlots())) {
                return null;
            }
            for (int inputSlot : this.getInputSlots()) {
                menu.consumeItem(inputSlot);
            }
            return new MachineRecipe(30, new ItemStack[]{ductTape, item}, new ItemStack[]{repairedItem});
        }
        return null;
    }

    private ItemStack repair(ItemStack item) {
        ItemStack repaired = item.clone();
        ItemMeta meta = repaired.getItemMeta();
        short maxDurability = item.getType().getMaxDurability();
        int repairPercentage = 100 / this.repairFactor;
        short durability = (short)(((Damageable)meta).getDamage() - maxDurability / repairPercentage);
        if (durability < 0) {
            durability = 0;
        }
        ((Damageable)meta).setDamage((int)durability);
        repaired.setItemMeta(meta);
        return repaired;
    }
}

