/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.listeners;

import io.github.thebusybiscuit.slimefun4.core.attributes.WitherProof;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.Iterator;
import javax.annotation.Nonnull;
import me.mrCookieSlime.Slimefun.Objects.SlimefunBlockHandler;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.UnregisterReason;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;

public class ExplosionsListener
implements Listener {
    public ExplosionsListener(@Nonnull SlimefunPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent e) {
        Iterator blocks = e.blockList().iterator();
        while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            SlimefunItem item = BlockStorage.check(block);
            if (item == null) continue;
            blocks.remove();
            if (item instanceof WitherProof) continue;
            SlimefunBlockHandler blockHandler = SlimefunPlugin.getRegistry().getBlockHandlers().get(item.getId());
            boolean success = true;
            if (blockHandler != null) {
                success = blockHandler.onBreak(null, block, item, UnregisterReason.EXPLODE);
            }
            if (!success) continue;
            BlockStorage.clearBlockInfo(block);
            block.setType(Material.AIR);
        }
    }
}

