/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.blocks;

import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class RepairedSpawner
extends SimpleSlimefunItem<BlockPlaceHandler> {
    public RepairedSpawner(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    @Override
    public BlockPlaceHandler getItemHandler() {
        return new BlockPlaceHandler(true){

            @Override
            public void onPlayerPlace(BlockPlaceEvent e) {
                this.onPlace(e.getItemInHand(), (BlockEvent)e);
            }

            @Override
            public void onBlockPlacerPlace(BlockPlacerPlaceEvent e) {
                this.onPlace(e.getItemStack(), e);
            }

            private void onPlace(ItemStack item, BlockEvent e) {
                Optional<EntityType> entity = RepairedSpawner.this.getEntityType(item);
                if (entity.isPresent() && e.getBlock().getType() == Material.SPAWNER) {
                    CreatureSpawner spawner = (CreatureSpawner)e.getBlock().getState();
                    spawner.setSpawnedType(entity.get());
                    spawner.update(true, false);
                }
            }
        };
    }

    public Optional<EntityType> getEntityType(ItemStack item) {
        for (String line : item.getItemMeta().getLore()) {
            if (!ChatColor.stripColor((String)line).startsWith("Type: ") || line.contains("<Type>")) continue;
            EntityType type = EntityType.valueOf((String)ChatColor.stripColor((String)line).replace("Type: ", "").replace(' ', '_').toUpperCase(Locale.ROOT));
            return Optional.of(type);
        }
        return Optional.empty();
    }

    @Override
    public Collection<ItemStack> getDrops() {
        return new ArrayList<ItemStack>();
    }
}

