/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.core.services.PersistentDataService;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.PaperLib;
import io.github.thebusybiscuit.slimefun4.libraries.paperlib.features.blockstatesnapshot.BlockStateSnapshotResult;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.plugin.Plugin;

public class BlockDataService
implements PersistentDataService,
Keyed {
    private final NamespacedKey namespacedKey;

    public BlockDataService(@Nonnull Plugin plugin, @Nonnull String key) {
        this.namespacedKey = new NamespacedKey(plugin, key);
    }

    public NamespacedKey getKey() {
        return this.namespacedKey;
    }

    public void setBlockData(@Nonnull Block b, @Nonnull String value) {
        BlockStateSnapshotResult result = PaperLib.getBlockState(b, false);
        BlockState state = result.getState();
        if (state instanceof TileState) {
            this.setString((TileState)state, this.namespacedKey, value);
            if (result.isSnapshot()) {
                state.update();
            }
        }
    }

    public Optional<String> getBlockData(@Nonnull Block b) {
        BlockState state = PaperLib.getBlockState(b, false).getState();
        if (state instanceof TileState) {
            return this.getString((TileState)state, this.namespacedKey);
        }
        return Optional.empty();
    }

    public boolean isTileEntity(@Nullable Material type) {
        if (type == null || type.isAir()) {
            return false;
        }
        switch (type) {
            case PLAYER_HEAD: 
            case PLAYER_WALL_HEAD: 
            case CHEST: 
            case DISPENSER: 
            case BREWING_STAND: 
            case DROPPER: 
            case FURNACE: 
            case BLAST_FURNACE: 
            case HOPPER: 
            case LECTERN: 
            case JUKEBOX: 
            case ENDER_CHEST: 
            case ENCHANTING_TABLE: 
            case DAYLIGHT_DETECTOR: 
            case SMOKER: 
            case BARREL: 
            case SPAWNER: 
            case BEACON: {
                return true;
            }
        }
        return false;
    }
}

