/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines.AbstractGrowthAccelerator;
import io.github.thebusybiscuit.slimefun4.utils.SlimefunUtils;
import io.github.thebusybiscuit.slimefun4.utils.itemstack.ItemStackWrapper;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;

public abstract class CropGrowthAccelerator
extends AbstractGrowthAccelerator {
    private static final ItemStack organicFertilizer = new ItemStackWrapper(SlimefunItems.FERTILIZER);

    public CropGrowthAccelerator(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
    }

    public abstract int getEnergyConsumption();

    public abstract int getRadius();

    public abstract int getSpeed();

    @Override
    public int getCapacity() {
        return 1024;
    }

    @Override
    protected void tick(Block b) {
        BlockMenu inv = BlockStorage.getInventory(b);
        if (this.getCharge(b.getLocation()) >= this.getEnergyConsumption()) {
            for (int x = -this.getRadius(); x <= this.getRadius(); ++x) {
                for (int z = -this.getRadius(); z <= this.getRadius(); ++z) {
                    Block block = b.getRelative(x, 0, z);
                    if (!SlimefunTag.CROP_GROWTH_ACCELERATOR_BLOCKS.isTagged(block.getType()) || !this.grow(b, inv, block)) continue;
                    return;
                }
            }
        }
    }

    private boolean grow(Block machine, BlockMenu inv, Block crop) {
        Ageable ageable = (Ageable)crop.getBlockData();
        if (ageable.getAge() < ageable.getMaximumAge()) {
            for (int slot : this.getInputSlots()) {
                if (!SlimefunUtils.isItemSimilar(inv.getItemInSlot(slot), organicFertilizer, false, false)) continue;
                this.removeCharge(machine.getLocation(), this.getEnergyConsumption());
                inv.consumeItem(slot);
                ageable.setAge(ageable.getAge() + 1);
                crop.setBlockData((BlockData)ageable);
                crop.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, crop.getLocation().add(0.5, 0.5, 0.5), 4, (double)0.1f, (double)0.1f, (double)0.1f);
                return true;
            }
        }
        return false;
    }
}

