/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.core.services;

import io.github.thebusybiscuit.slimefun4.core.services.PersistentDataService;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CustomItemDataService
implements PersistentDataService,
Keyed {
    private final NamespacedKey namespacedKey;

    public CustomItemDataService(@Nonnull Plugin plugin, @Nonnull String key) {
        this.namespacedKey = new NamespacedKey(plugin, key);
    }

    public NamespacedKey getKey() {
        return this.namespacedKey;
    }

    public void setItemData(@Nonnull ItemStack item, @Nonnull String id) {
        Validate.notNull((Object)item, (String)"The Item cannot be null!");
        Validate.notNull((Object)id, (String)"Cannot store null on an Item!");
        ItemMeta im = item.getItemMeta();
        this.setItemData(im, id);
        item.setItemMeta(im);
    }

    public void setItemData(@Nonnull ItemMeta im, @Nonnull String id) {
        Validate.notNull((Object)im, (String)"The ItemMeta cannot be null!");
        Validate.notNull((Object)id, (String)"Cannot store null on an ItemMeta!");
        this.setString(im, this.namespacedKey, id);
    }

    @Nonnull
    public Optional<String> getItemData(@Nullable ItemStack item) {
        if (item == null || item.getType() == Material.AIR || !item.hasItemMeta()) {
            return Optional.empty();
        }
        return this.getItemData(item.getItemMeta());
    }

    @Nonnull
    public Optional<String> getItemData(@Nonnull ItemMeta meta) {
        Validate.notNull((Object)meta, (String)"Cannot read data from null!");
        return this.getString(meta, this.namespacedKey);
    }
}

