/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest.apache;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.ProgressMonitor;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.UnirestException;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.apache.MonitoringStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.InputStreamBody;

class MonitoringStreamBody
extends InputStreamBody {
    private final ProgressMonitor monitor;
    private final long length;
    private final String name;
    private final String fileName;

    public MonitoringStreamBody(InputStream in, ContentType contentType, String fileName, String fieldName, ProgressMonitor monitor) {
        super(in, contentType, fileName);
        this.fileName = fileName;
        try {
            this.monitor = monitor;
            this.name = fieldName;
            this.length = in.available();
        }
        catch (IOException e) {
            throw new UnirestException(e);
        }
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (Objects.nonNull(this.monitor)) {
            super.writeTo(new MonitoringStream(out, this.length, this.name, this.fileName, this.monitor));
        } else {
            super.writeTo(out);
        }
    }
}

