/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.miner;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.core.multiblocks.MultiBlockMachine;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.multiblocks.miner.ActiveMiner;
import io.github.thebusybiscuit.slimefun4.utils.tags.SlimefunTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.abstractItems.MachineFuel;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.chat.ChatColors;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class IndustrialMiner
extends MultiBlockMachine {
    protected final Map<Location, ActiveMiner> activeMiners = new HashMap<Location, ActiveMiner>();
    protected final List<MachineFuel> fuelTypes = new ArrayList<MachineFuel>();
    private final int range;
    private final boolean silkTouch;
    private final ItemSetting<Boolean> canMineAncientDebris = new ItemSetting<Boolean>("can-mine-ancient-debris", false);

    public IndustrialMiner(Category category, SlimefunItemStack item, Material baseMaterial, boolean silkTouch, int range) {
        super(category, item, new ItemStack[]{null, null, null, new CustomItem(Material.PISTON, "Piston (facing up)", new String[0]), new ItemStack(Material.CHEST), new CustomItem(Material.PISTON, "Piston (facing up)", new String[0]), new ItemStack(baseMaterial), new ItemStack(SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_14) ? Material.BLAST_FURNACE : Material.FURNACE), new ItemStack(baseMaterial)}, BlockFace.UP);
        this.range = range;
        this.silkTouch = silkTouch;
        this.registerDefaultFuelTypes();
        this.addItemSetting(this.canMineAncientDebris);
    }

    public boolean hasSilkTouch() {
        return this.silkTouch;
    }

    public int getRange() {
        return this.range;
    }

    protected void registerDefaultFuelTypes() {
        this.fuelTypes.add(new MachineFuel(4, new ItemStack(Material.COAL)));
        this.fuelTypes.add(new MachineFuel(4, new ItemStack(Material.CHARCOAL)));
        this.fuelTypes.add(new MachineFuel(40, new ItemStack(Material.COAL_BLOCK)));
        this.fuelTypes.add(new MachineFuel(10, new ItemStack(Material.DRIED_KELP_BLOCK)));
        this.fuelTypes.add(new MachineFuel(4, new ItemStack(Material.BLAZE_ROD)));
        for (Material mat : Tag.LOGS.getValues()) {
            this.fuelTypes.add(new MachineFuel(1, new ItemStack(mat)));
        }
    }

    public ItemStack getOutcome(Material ore) {
        if (this.hasSilkTouch()) {
            return new ItemStack(ore);
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        switch (ore) {
            case COAL_ORE: {
                return new ItemStack(Material.COAL);
            }
            case DIAMOND_ORE: {
                return new ItemStack(Material.DIAMOND);
            }
            case EMERALD_ORE: {
                return new ItemStack(Material.EMERALD);
            }
            case NETHER_QUARTZ_ORE: {
                return new ItemStack(Material.QUARTZ);
            }
            case REDSTONE_ORE: {
                return new ItemStack(Material.REDSTONE, 4 + ((Random)random).nextInt(2));
            }
            case LAPIS_ORE: {
                return new ItemStack(Material.LAPIS_LAZULI, 4 + ((Random)random).nextInt(4));
            }
        }
        return new ItemStack(ore);
    }

    public void addFuelType(int ores, ItemStack item) {
        Validate.isTrue((ores > 1 && ores % 2 == 0 ? 1 : 0) != 0, (String)"The amount of ores must be at least 2 and a multiple of 2.");
        this.fuelTypes.add(new MachineFuel(ores / 2, item));
    }

    @Override
    public String getLabelLocalPath() {
        return "guide.tooltips.recipes.generator";
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (MachineFuel fuel : this.fuelTypes) {
            ItemStack item = fuel.getInput().clone();
            ItemMeta im = item.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(ChatColors.color("&8\u21e8 &7Lasts for max. " + fuel.getTicks() + " Ores"));
            im.setLore(lore);
            item.setItemMeta(im);
            list.add(item);
        }
        return list;
    }

    @Override
    public void onInteract(Player p, Block b) {
        if (this.activeMiners.containsKey(b.getLocation())) {
            SlimefunPlugin.getLocalization().sendMessage((CommandSender)p, "machines.INDUSTRIAL_MINER.already-running");
            return;
        }
        Block chest = b.getRelative(BlockFace.UP);
        Block[] pistons = this.findPistons(chest);
        int mod = this.getRange();
        Block start = b.getRelative(-mod, -1, -mod);
        Block end = b.getRelative(mod, -1, mod);
        ActiveMiner instance = new ActiveMiner(this, p.getUniqueId(), chest, pistons, start, end);
        instance.start(b);
    }

    private Block[] findPistons(Block chest) {
        Block northern = chest.getRelative(BlockFace.NORTH);
        if (northern.getType() == Material.PISTON) {
            return new Block[]{northern, chest.getRelative(BlockFace.SOUTH)};
        }
        return new Block[]{chest.getRelative(BlockFace.WEST), chest.getRelative(BlockFace.EAST)};
    }

    public boolean canMine(Material type) {
        if (SlimefunTag.INDUSTRIAL_MINER_ORES.isTagged(type)) {
            return true;
        }
        if (SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_16)) {
            return type == Material.ANCIENT_DEBRIS && this.canMineAncientDebris.getValue() != false;
        }
        return false;
    }
}

