/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.androids;

import io.github.thebusybiscuit.slimefun4.api.MinecraftVersion;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.AndroidType;
import io.github.thebusybiscuit.slimefun4.implementation.items.androids.ProgrammableAndroid;
import java.util.concurrent.ThreadLocalRandom;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.RandomizedSet;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;

public class FisherAndroid
extends ProgrammableAndroid {
    private final RandomizedSet<ItemStack> fishingLoot = new RandomizedSet();

    public FisherAndroid(Category category, int tier, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, tier, item, recipeType, recipe);
        for (Material fish : Tag.ITEMS_FISHES.getValues()) {
            this.fishingLoot.add(new ItemStack(fish), 25.0f);
        }
        this.fishingLoot.add(new ItemStack(Material.BONE), 10.0f);
        this.fishingLoot.add(new ItemStack(Material.STRING), 10.0f);
        this.fishingLoot.add(new ItemStack(Material.INK_SAC), 8.0f);
        this.fishingLoot.add(new ItemStack(Material.KELP), 6.0f);
        this.fishingLoot.add(new ItemStack(Material.STICK), 5.0f);
        this.fishingLoot.add(new ItemStack(Material.ROTTEN_FLESH), 3.0f);
        this.fishingLoot.add(new ItemStack(Material.LEATHER), 2.0f);
        if (SlimefunPlugin.getMinecraftVersion().isAtLeast(MinecraftVersion.MINECRAFT_1_14)) {
            this.fishingLoot.add(new ItemStack(Material.BAMBOO), 3.0f);
        }
        this.fishingLoot.add(new ItemStack(Material.SADDLE), 1.0f);
        this.fishingLoot.add(new ItemStack(Material.NAME_TAG), 1.0f);
        this.fishingLoot.add(new ItemStack(Material.NAUTILUS_SHELL), 1.0f);
    }

    @Override
    public AndroidType getAndroidType() {
        return AndroidType.FISHERMAN;
    }

    @Override
    protected void fish(Block b, BlockMenu menu) {
        Block water = b.getRelative(BlockFace.DOWN);
        if (water.getType() == Material.WATER) {
            water.getWorld().playSound(water.getLocation(), Sound.ENTITY_PLAYER_SPLASH, 0.3f, 0.7f);
            if (ThreadLocalRandom.current().nextInt(100) < 10 * this.getTier()) {
                ItemStack drop = this.fishingLoot.getRandom();
                menu.pushItem(drop, this.getOutputSlots());
            }
        }
    }
}

