/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.api.items.settings;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.bukkit.Material;
import org.bukkit.Tag;

public class MaterialTagSetting
extends ItemSetting<List<String>> {
    private final Tag<Material> defaultTag;

    @ParametersAreNonnullByDefault
    public MaterialTagSetting(String key, Tag<Material> defaultTag) {
        super(key, MaterialTagSetting.getAsStringList(defaultTag));
        this.defaultTag = defaultTag;
    }

    @Nonnull
    public Tag<Material> getDefaultTag() {
        return this.defaultTag;
    }

    @Override
    @Nonnull
    protected String getErrorMessage() {
        return "This List can only contain Materials in the format of e.g. REDSTONE_BLOCK";
    }

    @Override
    public boolean validateInput(List<String> input) {
        if (super.validateInput(input)) {
            for (String value : input) {
                Material material = Material.matchMaterial((String)value);
                if (material != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nonnull
    private static List<String> getAsStringList(@Nonnull Tag<Material> tag) {
        return tag.getValues().stream().map(Enum::name).collect(Collectors.toList());
    }
}

