/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.libraries.unirest;

import io.github.thebusybiscuit.slimefun4.libraries.unirest.BaseRequest;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.Body;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.BodyPart;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.Config;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.HttpMethod;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.JsonPatch;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.JsonPatchRequest;
import io.github.thebusybiscuit.slimefun4.libraries.unirest.UnibodyString;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

class HttpRequestJsonPatch
extends BaseRequest<JsonPatchRequest>
implements JsonPatchRequest {
    private JsonPatch items = new JsonPatch();

    HttpRequestJsonPatch(Config config, String url) {
        super(config, HttpMethod.PATCH, url);
        this.header("Content-Type", "application/json-patch+json");
    }

    @Override
    public JsonPatchRequest add(String path, Object value) {
        this.items.add(path, value);
        return this;
    }

    @Override
    public JsonPatchRequest remove(String path) {
        this.items.remove(path);
        return this;
    }

    @Override
    public JsonPatchRequest replace(String path, Object value) {
        this.items.replace(path, value);
        return this;
    }

    @Override
    public JsonPatchRequest test(String path, Object value) {
        this.items.test(path, value);
        return this;
    }

    @Override
    public JsonPatchRequest move(String from, String path) {
        this.items.move(from, path);
        return this;
    }

    @Override
    public JsonPatchRequest copy(String from, String path) {
        this.items.copy(from, path);
        return this;
    }

    @Override
    public Optional<Body> getBody() {
        return Optional.of(this);
    }

    @Override
    public BodyPart uniPart() {
        String bodyAsString = this.items.toString();
        return new UnibodyString(bodyAsString, StandardCharsets.UTF_8);
    }

    @Override
    public boolean isMultiPart() {
        return false;
    }

    @Override
    public boolean isEntityBody() {
        return true;
    }
}

