/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.electric.machines;

import io.github.thebusybiscuit.slimefun4.api.events.BlockPlacerPlaceEvent;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.handlers.BlockPlaceHandler;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import me.mrCookieSlime.CSCoreLibPlugin.Configuration.Config;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ChestMenu;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.ClickAction;
import me.mrCookieSlime.CSCoreLibPlugin.general.Inventory.Item.CustomItemSerializer;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.SlimefunItem;
import me.mrCookieSlime.Slimefun.Objects.SlimefunItem.interfaces.InventoryBlock;
import me.mrCookieSlime.Slimefun.Objects.handlers.BlockTicker;
import me.mrCookieSlime.Slimefun.api.BlockStorage;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenuPreset;
import me.mrCookieSlime.Slimefun.api.inventory.DirtyChestMenu;
import me.mrCookieSlime.Slimefun.api.item_transport.ItemTransportFlow;
import me.mrCookieSlime.Slimefun.cscorelib2.item.CustomItem;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AutomatedCraftingChamber
extends SlimefunItem
implements InventoryBlock,
EnergyNetComponent {
    private final int[] border = new int[]{0, 1, 3, 4, 5, 7, 8, 13, 14, 15, 16, 17, 50, 51, 52, 53};
    private final int[] inputBorder = new int[]{9, 10, 11, 12, 13, 18, 22, 27, 31, 36, 40, 45, 46, 47, 48, 49};
    private final int[] outputBorder = new int[]{23, 24, 25, 26, 32, 35, 41, 42, 43, 44};

    public AutomatedCraftingChamber(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        new BlockMenuPreset(this.getID(), "&6Automated Crafting Chamber"){

            @Override
            public void init() {
                AutomatedCraftingChamber.this.constructMenu(this);
            }

            @Override
            public void newInstance(BlockMenu menu, Block b) {
                if (!BlockStorage.hasBlockInfo(b) || BlockStorage.getLocationInfo(b.getLocation(), "enabled") == null || BlockStorage.getLocationInfo(b.getLocation(), "enabled").equals(String.valueOf(false))) {
                    menu.replaceExistingItem(6, new CustomItem(Material.GUNPOWDER, "&7Enabled: &4\u2718", "", "&e> Click to enable this Machine"));
                    menu.addMenuClickHandler(6, (p, slot, item, action) -> {
                        BlockStorage.addBlockInfo(b, "enabled", String.valueOf(true));
                        this.newInstance(menu, b);
                        return false;
                    });
                } else {
                    menu.replaceExistingItem(6, new CustomItem(Material.REDSTONE, "&7Enabled: &2\u2714", "", "&e> Click to disable this Machine"));
                    menu.addMenuClickHandler(6, (p, slot, item, action) -> {
                        BlockStorage.addBlockInfo(b, "enabled", String.valueOf(false));
                        this.newInstance(menu, b);
                        return false;
                    });
                }
                menu.replaceExistingItem(7, new CustomItem(Material.CRAFTING_TABLE, "&7Craft Last", "", "&e> Click to craft the last shaped recipe", "&cOnly works with the last one"));
                menu.addMenuClickHandler(7, (p, slot, item, action) -> {
                    AutomatedCraftingChamber.this.tick(b, true);
                    return false;
                });
            }

            @Override
            public boolean canOpen(Block b, Player p) {
                return p.hasPermission("slimefun.inventory.bypass") || SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)p, b.getLocation(), ProtectableAction.ACCESS_INVENTORIES);
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(ItemTransportFlow flow) {
                return new int[0];
            }

            @Override
            public int[] getSlotsAccessedByItemTransport(DirtyChestMenu menu, ItemTransportFlow flow, ItemStack item) {
                if (flow == ItemTransportFlow.WITHDRAW) {
                    return AutomatedCraftingChamber.this.getOutputSlots();
                }
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int slot : AutomatedCraftingChamber.this.getInputSlots()) {
                    if (menu.getItemInSlot(slot) == null) continue;
                    slots.add(slot);
                }
                Collections.sort(slots, AutomatedCraftingChamber.this.compareSlots(menu));
                int[] array = new int[slots.size()];
                for (int i = 0; i < slots.size(); ++i) {
                    array[i] = (Integer)slots.get(i);
                }
                return array;
            }
        };
        this.addItemHandler(this.onPlace());
        AutomatedCraftingChamber.registerBlockHandler(this.getID(), (p, b, stack, reason) -> {
            BlockMenu inv = BlockStorage.getInventory(b);
            if (inv != null) {
                inv.dropItems(b.getLocation(), this.getInputSlots());
                inv.dropItems(b.getLocation(), this.getOutputSlots());
            }
            return true;
        });
    }

    private BlockPlaceHandler onPlace() {
        return new BlockPlaceHandler(true){

            @Override
            public void onPlayerPlace(BlockPlaceEvent e) {
                BlockStorage.addBlockInfo(e.getBlock(), "enabled", String.valueOf(false));
            }

            @Override
            public void onBlockPlacerPlace(BlockPlacerPlaceEvent e) {
                BlockStorage.addBlockInfo(e.getBlock(), "enabled", String.valueOf(false));
            }
        };
    }

    private Comparator<Integer> compareSlots(DirtyChestMenu menu) {
        return (slot1, slot2) -> menu.getItemInSlot((int)slot1).getAmount() - menu.getItemInSlot((int)slot2).getAmount();
    }

    protected void constructMenu(BlockMenuPreset preset) {
        for (int i : this.border) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : this.inputBorder) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.BLUE_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : this.outputBorder) {
            preset.addItem(i, new CustomItem(new ItemStack(Material.ORANGE_STAINED_GLASS_PANE), " ", new String[0]), (p, slot, item, action) -> false);
        }
        for (int i : this.getOutputSlots()) {
            preset.addMenuClickHandler(i, (ChestMenu.MenuClickHandler)new ChestMenu.AdvancedMenuClickHandler(){

                public boolean onClick(Player p, int slot, ItemStack cursor, ClickAction action) {
                    return false;
                }

                public boolean onClick(InventoryClickEvent e, Player p, int slot, ItemStack cursor, ClickAction action) {
                    return cursor == null || cursor.getType() == null || cursor.getType() == Material.AIR;
                }
            });
        }
        preset.addItem(2, new CustomItem(new ItemStack(Material.CRAFTING_TABLE), "&eRecipe", "", "&bPut in the Recipe you want to craft", "&4Enhanced Crafting Table Recipes ONLY"), (p, slot, item, action) -> false);
    }

    public abstract int getEnergyConsumption();

    @Override
    public int[] getInputSlots() {
        return new int[]{19, 20, 21, 28, 29, 30, 37, 38, 39};
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{33, 34};
    }

    @Override
    public EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    @Override
    public void preRegister() {
        this.addItemHandler(new BlockTicker(){

            @Override
            public void tick(Block b, SlimefunItem sf, Config data) {
                AutomatedCraftingChamber.this.tick(b, false);
            }

            @Override
            public boolean isSynchronized() {
                return false;
            }
        });
    }

    protected void tick(Block block, boolean craftLast) {
        if (!craftLast && BlockStorage.getLocationInfo(block.getLocation(), "enabled").equals(String.valueOf(false))) {
            return;
        }
        if (this.getCharge(block.getLocation()) < this.getEnergyConsumption()) {
            return;
        }
        String input = this.getSerializedInput(block, craftLast);
        this.testInputAgainstRecipes(block, input);
    }

    private String getSerializedInput(Block block, boolean craftLast) {
        BlockMenu menu = BlockStorage.getInventory(block);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        boolean lastIteration = false;
        for (int j = 0; j < 9; ++j) {
            ItemStack item;
            if (i > 0) {
                builder.append(" </slot> ");
            }
            if ((item = menu.getItemInSlot(this.getInputSlots()[j])) != null && item.getAmount() == 1) {
                if (craftLast) {
                    lastIteration = true;
                } else {
                    return "";
                }
            }
            builder.append(CustomItemSerializer.serialize((ItemStack)item, (CustomItemSerializer.ItemFlag[])new CustomItemSerializer.ItemFlag[]{CustomItemSerializer.ItemFlag.MATERIAL, CustomItemSerializer.ItemFlag.ITEMMETA_DISPLAY_NAME, CustomItemSerializer.ItemFlag.ITEMMETA_LORE}));
            ++i;
        }
        if (craftLast && !lastIteration) {
            return "";
        }
        return builder.toString();
    }

    private void testInputAgainstRecipes(Block block, String input) {
        BlockMenu menu = BlockStorage.getInventory(block);
        ItemStack output = SlimefunPlugin.getRegistry().getAutomatedCraftingChamberRecipes().get(input);
        if (output != null && menu.fits(output, this.getOutputSlots())) {
            menu.pushItem(output.clone(), this.getOutputSlots());
            this.removeCharge(block.getLocation(), this.getEnergyConsumption());
            for (int j = 0; j < 9; ++j) {
                if (menu.getItemInSlot(this.getInputSlots()[j]) == null) continue;
                menu.consumeItem(this.getInputSlots()[j]);
            }
        }
    }
}

