/*
 * Decompiled with CFR 0.152.
 */
package io.github.thebusybiscuit.slimefun4.implementation.items.tools;

import io.github.thebusybiscuit.slimefun4.api.items.ItemSetting;
import io.github.thebusybiscuit.slimefun4.core.attributes.RecipeDisplayItem;
import io.github.thebusybiscuit.slimefun4.core.handlers.EntityInteractHandler;
import io.github.thebusybiscuit.slimefun4.core.handlers.ItemUseHandler;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunItems;
import io.github.thebusybiscuit.slimefun4.implementation.SlimefunPlugin;
import io.github.thebusybiscuit.slimefun4.implementation.items.SimpleSlimefunItem;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import me.mrCookieSlime.Slimefun.Lists.RecipeType;
import me.mrCookieSlime.Slimefun.Objects.Category;
import me.mrCookieSlime.Slimefun.api.SlimefunItemStack;
import me.mrCookieSlime.Slimefun.cscorelib2.collections.RandomizedSet;
import me.mrCookieSlime.Slimefun.cscorelib2.protection.ProtectableAction;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

public class GoldPan
extends SimpleSlimefunItem<ItemUseHandler>
implements RecipeDisplayItem {
    private final RandomizedSet<ItemStack> randomizer = new RandomizedSet();
    private final Set<GoldPanDrop> drops = new HashSet<GoldPanDrop>();

    @ParametersAreNonnullByDefault
    public GoldPan(Category category, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(category, item, recipeType, recipe);
        this.drops.addAll(this.getGoldPanDrops());
        this.addItemSetting(this.drops.toArray(new GoldPanDrop[0]));
        this.addItemHandler(this.onEntityInteract());
    }

    @Nonnull
    protected Material getTargetMaterial() {
        return Material.GRAVEL;
    }

    protected Set<GoldPanDrop> getGoldPanDrops() {
        HashSet<GoldPanDrop> settings = new HashSet<GoldPanDrop>();
        settings.add(new GoldPanDrop("chance.FLINT", 40, new ItemStack(Material.FLINT)));
        settings.add(new GoldPanDrop("chance.CLAY", 20, new ItemStack(Material.CLAY_BALL)));
        settings.add(new GoldPanDrop("chance.SIFTED_ORE", 35, SlimefunItems.SIFTED_ORE));
        settings.add(new GoldPanDrop("chance.IRON_NUGGET", 5, new ItemStack(Material.IRON_NUGGET)));
        return settings;
    }

    @Override
    public void postRegister() {
        super.postRegister();
        this.updateRandomizer();
    }

    protected void updateRandomizer() {
        this.randomizer.clear();
        for (GoldPanDrop setting : this.drops) {
            this.randomizer.add(setting.getOutput(), ((Integer)setting.getValue()).intValue());
        }
        if (this.randomizer.sumWeights() < 100.0f) {
            this.randomizer.add(new ItemStack(Material.AIR), 100.0f - this.randomizer.sumWeights());
        }
    }

    @Nonnull
    public ItemStack getRandomOutput() {
        return this.randomizer.getRandom();
    }

    @Override
    public String getLabelLocalPath() {
        return "guide.tooltips.recipes.gold-pan";
    }

    @Override
    public ItemUseHandler getItemHandler() {
        return e -> {
            Block b;
            Optional<Block> block = e.getClickedBlock();
            if (block.isPresent() && (b = block.get()).getType() == this.getTargetMaterial() && SlimefunPlugin.getProtectionManager().hasPermission((OfflinePlayer)e.getPlayer(), b.getLocation(), ProtectableAction.BREAK_BLOCK)) {
                ItemStack output = this.getRandomOutput();
                b.getWorld().playEffect(b.getLocation(), Effect.STEP_SOUND, (Object)b.getType());
                b.setType(Material.AIR);
                if (output.getType() != Material.AIR) {
                    b.getWorld().dropItemNaturally(b.getLocation(), output.clone());
                }
            }
            e.cancel();
        };
    }

    public EntityInteractHandler onEntityInteract() {
        return (e, item, offHand) -> e.setCancelled(true);
    }

    @Override
    public List<ItemStack> getDisplayRecipes() {
        LinkedList<ItemStack> recipes = new LinkedList<ItemStack>();
        for (GoldPanDrop drop : this.drops) {
            if ((Integer)drop.getValue() <= 0) continue;
            recipes.add(new ItemStack(this.getTargetMaterial()));
            recipes.add(drop.getOutput());
        }
        return recipes;
    }

    public class GoldPanDrop
    extends ItemSetting<Integer> {
        private final ItemStack output;

        protected GoldPanDrop(String key, int defaultValue, ItemStack output) {
            super(key, defaultValue);
            this.output = output;
        }

        @Override
        public boolean validateInput(Integer input) {
            return super.validateInput(input) && input >= 0;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        @Override
        public void update(Integer newValue) {
            super.update(newValue);
            GoldPan.this.updateRandomizer();
        }
    }
}

